<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationResults Structs
 * Meta informations extracted from the WSDL
 * - documentation: ApplicationResults can be used anywhere where Results is referenced, specifically as the contents of a Sabre SOAP Fault/detail element.
 * - substitutionGroup: Results
 * - type: ApplicationResults
 * @subpackage Structs
 */
class ApplicationResults extends Results
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $status;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ProblemInformation[]
     */
    public $Success;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ProblemInformation[]
     */
    public $Error;
    /**
     * The Warning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ProblemInformation[]
     */
    public $Warning;
    /**
     * Constructor method for ApplicationResults
     * @uses ApplicationResults::setStatus()
     * @uses ApplicationResults::setSuccess()
     * @uses ApplicationResults::setError()
     * @uses ApplicationResults::setWarning()
     * @param string $status
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation[] $success
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation[] $error
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation[] $warning
     */
    public function __construct($status = null, array $success = array(), array $error = array(), array $warning = array())
    {
        $this
            ->setStatus($status)
            ->setSuccess($success)
            ->setError($error)
            ->setWarning($warning);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Sabre\OTAAirPrice\Enums\CompletionCodes::valueIsValid()
     * @uses \Sabre\OTAAirPrice\Enums\CompletionCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Sabre\OTAAirPrice\Structs\ApplicationResults
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get Success value
     * @return \Sabre\OTAAirPrice\Structs\ProblemInformation[]|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation[] $success
     * @return \Sabre\OTAAirPrice\Structs\ApplicationResults
     */
    public function setSuccess(array $success = array())
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Add item to Success value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation $item
     * @return \Sabre\OTAAirPrice\Structs\ApplicationResults
     */
    public function addToSuccess(\Sabre\OTAAirPrice\Structs\ProblemInformation $item)
    {
        $this->Success[] = $item;
        return $this;
    }
    /**
     * Get Error value
     * @return \Sabre\OTAAirPrice\Structs\ProblemInformation[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation[] $error
     * @return \Sabre\OTAAirPrice\Structs\ApplicationResults
     */
    public function setError(array $error = array())
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation $item
     * @return \Sabre\OTAAirPrice\Structs\ApplicationResults
     */
    public function addToError(\Sabre\OTAAirPrice\Structs\ProblemInformation $item)
    {
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \Sabre\OTAAirPrice\Structs\ProblemInformation[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation[] $warning
     * @return \Sabre\OTAAirPrice\Structs\ApplicationResults
     */
    public function setWarning(array $warning = array())
    {
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ProblemInformation $item
     * @return \Sabre\OTAAirPrice\Structs\ApplicationResults
     */
    public function addToWarning(\Sabre\OTAAirPrice\Structs\ProblemInformation $item)
    {
        $this->Warning[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\ApplicationResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
