<?php

namespace Sabre\OTAAirPrice\Enums;

/**
 * This class stands for TraceRole Enums
 * @subpackage Enumerations
 */
class TraceRole
{
    /**
     * Constant for value 'consumer'
     * @return string 'consumer'
     */
    const VALUE_CONSUMER = 'consumer';
    /**
     * Constant for value 'provider'
     * @return string 'provider'
     */
    const VALUE_PROVIDER = 'provider';
    /**
     * Constant for value 'gateway'
     * @return string 'gateway'
     */
    const VALUE_GATEWAY = 'gateway';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONSUMER
     * @uses self::VALUE_PROVIDER
     * @uses self::VALUE_GATEWAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONSUMER,
            self::VALUE_PROVIDER,
            self::VALUE_GATEWAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
