<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket Structs
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The Simultaneous
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Simultaneous;
    /**
     * The InterlineAgreement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\InterlineAgreement[]
     */
    public $InterlineAgreement;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The CarrierCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CarrierCode;
    /**
     * The ValidatingCarrierType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ValidatingCarrierType;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setNumber()
     * @uses Ticket::setSimultaneous()
     * @uses Ticket::setInterlineAgreement()
     * @uses Ticket::setType()
     * @uses Ticket::setCarrierCode()
     * @uses Ticket::setValidatingCarrierType()
     * @param string $number
     * @param string $simultaneous
     * @param \Sabre\OTAAirPrice\Structs\InterlineAgreement[] $interlineAgreement
     * @param string $type
     * @param string $carrierCode
     * @param string $validatingCarrierType
     */
    public function __construct($number = null, $simultaneous = null, array $interlineAgreement = array(), $type = null, $carrierCode = null, $validatingCarrierType = null)
    {
        $this
            ->setNumber($number)
            ->setSimultaneous($simultaneous)
            ->setInterlineAgreement($interlineAgreement)
            ->setType($type)
            ->setCarrierCode($carrierCode)
            ->setValidatingCarrierType($validatingCarrierType);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\OTAAirPrice\Structs\Ticket
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Simultaneous value
     * @return string|null
     */
    public function getSimultaneous()
    {
        return $this->Simultaneous;
    }
    /**
     * Set Simultaneous value
     * @param string $simultaneous
     * @return \Sabre\OTAAirPrice\Structs\Ticket
     */
    public function setSimultaneous($simultaneous = null)
    {
        $this->Simultaneous = $simultaneous;
        return $this;
    }
    /**
     * Get InterlineAgreement value
     * @return \Sabre\OTAAirPrice\Structs\InterlineAgreement[]|null
     */
    public function getInterlineAgreement()
    {
        return $this->InterlineAgreement;
    }
    /**
     * Set InterlineAgreement value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\InterlineAgreement[] $interlineAgreement
     * @return \Sabre\OTAAirPrice\Structs\Ticket
     */
    public function setInterlineAgreement(array $interlineAgreement = array())
    {
        $this->InterlineAgreement = $interlineAgreement;
        return $this;
    }
    /**
     * Add item to InterlineAgreement value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\InterlineAgreement $item
     * @return \Sabre\OTAAirPrice\Structs\Ticket
     */
    public function addToInterlineAgreement(\Sabre\OTAAirPrice\Structs\InterlineAgreement $item)
    {
        $this->InterlineAgreement[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\OTAAirPrice\Structs\Ticket
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \Sabre\OTAAirPrice\Structs\Ticket
     */
    public function setCarrierCode($carrierCode = null)
    {
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get ValidatingCarrierType value
     * @return string|null
     */
    public function getValidatingCarrierType()
    {
        return $this->ValidatingCarrierType;
    }
    /**
     * Set ValidatingCarrierType value
     * @param string $validatingCarrierType
     * @return \Sabre\OTAAirPrice\Structs\Ticket
     */
    public function setValidatingCarrierType($validatingCarrierType = null)
    {
        $this->ValidatingCarrierType = $validatingCarrierType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
