<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax Structs
 * @subpackage Structs
 */
class Tax extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxName
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TaxName;
    /**
     * The TicketingTaxCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TicketingTaxCode;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The AmountPublished
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AmountPublished;
    /**
     * The PublishedCurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PublishedCurrencyCode;
    /**
     * The StationCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $StationCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The GoodAndServicesInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $GoodAndServicesInd;
    /**
     * Constructor method for Tax
     * @uses Tax::setAmount()
     * @uses Tax::setTaxCode()
     * @uses Tax::setTaxName()
     * @uses Tax::setTicketingTaxCode()
     * @uses Tax::setCode()
     * @uses Tax::setDescription()
     * @uses Tax::setCurrencyCode()
     * @uses Tax::setAmountPublished()
     * @uses Tax::setPublishedCurrencyCode()
     * @uses Tax::setStationCode()
     * @uses Tax::setCountryCode()
     * @uses Tax::setGoodAndServicesInd()
     * @param string $amount
     * @param string $taxCode
     * @param string $taxName
     * @param string $ticketingTaxCode
     * @param string $code
     * @param string $description
     * @param string $currencyCode
     * @param string $amountPublished
     * @param string $publishedCurrencyCode
     * @param string $stationCode
     * @param string $countryCode
     * @param bool $goodAndServicesInd
     */
    public function __construct($amount = null, $taxCode = null, $taxName = null, $ticketingTaxCode = null, $code = null, $description = null, $currencyCode = null, $amountPublished = null, $publishedCurrencyCode = null, $stationCode = null, $countryCode = null, $goodAndServicesInd = null)
    {
        $this
            ->setAmount($amount)
            ->setTaxCode($taxCode)
            ->setTaxName($taxName)
            ->setTicketingTaxCode($ticketingTaxCode)
            ->setCode($code)
            ->setDescription($description)
            ->setCurrencyCode($currencyCode)
            ->setAmountPublished($amountPublished)
            ->setPublishedCurrencyCode($publishedCurrencyCode)
            ->setStationCode($stationCode)
            ->setCountryCode($countryCode)
            ->setGoodAndServicesInd($goodAndServicesInd);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setTaxCode($taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->TaxName;
    }
    /**
     * Set TaxName value
     * @param string $taxName
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setTaxName($taxName = null)
    {
        $this->TaxName = $taxName;
        return $this;
    }
    /**
     * Get TicketingTaxCode value
     * @return string|null
     */
    public function getTicketingTaxCode()
    {
        return $this->TicketingTaxCode;
    }
    /**
     * Set TicketingTaxCode value
     * @param string $ticketingTaxCode
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setTicketingTaxCode($ticketingTaxCode = null)
    {
        $this->TicketingTaxCode = $ticketingTaxCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get AmountPublished value
     * @return string|null
     */
    public function getAmountPublished()
    {
        return $this->AmountPublished;
    }
    /**
     * Set AmountPublished value
     * @param string $amountPublished
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setAmountPublished($amountPublished = null)
    {
        $this->AmountPublished = $amountPublished;
        return $this;
    }
    /**
     * Get PublishedCurrencyCode value
     * @return string|null
     */
    public function getPublishedCurrencyCode()
    {
        return $this->PublishedCurrencyCode;
    }
    /**
     * Set PublishedCurrencyCode value
     * @param string $publishedCurrencyCode
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setPublishedCurrencyCode($publishedCurrencyCode = null)
    {
        $this->PublishedCurrencyCode = $publishedCurrencyCode;
        return $this;
    }
    /**
     * Get StationCode value
     * @return string|null
     */
    public function getStationCode()
    {
        return $this->StationCode;
    }
    /**
     * Set StationCode value
     * @param string $stationCode
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setStationCode($stationCode = null)
    {
        $this->StationCode = $stationCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get GoodAndServicesInd value
     * @return bool|null
     */
    public function getGoodAndServicesInd()
    {
        return $this->GoodAndServicesInd;
    }
    /**
     * Set GoodAndServicesInd value
     * @param bool $goodAndServicesInd
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public function setGoodAndServicesInd($goodAndServicesInd = null)
    {
        $this->GoodAndServicesInd = $goodAndServicesInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\Tax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
