<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellingFareData Structs
 * @subpackage Structs
 */
class SellingFareData extends AbstractStructBase
{
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\BaseFare
     */
    public $BaseFare;
    /**
     * The ConstructedTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ConstructedTotal
     */
    public $ConstructedTotal;
    /**
     * The Equivalent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Equivalent
     */
    public $Equivalent;
    /**
     * The TotalTaxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\TotalTaxes
     */
    public $TotalTaxes;
    /**
     * The TotalPerPassenger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\TotalPerPassenger
     */
    public $TotalPerPassenger;
    /**
     * The FareCalculation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\FareCalculation
     */
    public $FareCalculation;
    /**
     * The SellingFareTaxData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\SellingFareTaxData[]
     */
    public $SellingFareTaxData;
    /**
     * The SellingFareTaxBreakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\SellingFareTaxBreakdown[]
     */
    public $SellingFareTaxBreakdown;
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Summary[]
     */
    public $Summary;
    /**
     * The LayerTypeName
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LayerTypeName;
    /**
     * Constructor method for SellingFareData
     * @uses SellingFareData::setBaseFare()
     * @uses SellingFareData::setConstructedTotal()
     * @uses SellingFareData::setEquivalent()
     * @uses SellingFareData::setTotalTaxes()
     * @uses SellingFareData::setTotalPerPassenger()
     * @uses SellingFareData::setFareCalculation()
     * @uses SellingFareData::setSellingFareTaxData()
     * @uses SellingFareData::setSellingFareTaxBreakdown()
     * @uses SellingFareData::setSummary()
     * @uses SellingFareData::setLayerTypeName()
     * @param \Sabre\OTAAirPrice\Structs\BaseFare $baseFare
     * @param \Sabre\OTAAirPrice\Structs\ConstructedTotal $constructedTotal
     * @param \Sabre\OTAAirPrice\Structs\Equivalent $equivalent
     * @param \Sabre\OTAAirPrice\Structs\TotalTaxes $totalTaxes
     * @param \Sabre\OTAAirPrice\Structs\TotalPerPassenger $totalPerPassenger
     * @param \Sabre\OTAAirPrice\Structs\FareCalculation $fareCalculation
     * @param \Sabre\OTAAirPrice\Structs\SellingFareTaxData[] $sellingFareTaxData
     * @param \Sabre\OTAAirPrice\Structs\SellingFareTaxBreakdown[] $sellingFareTaxBreakdown
     * @param \Sabre\OTAAirPrice\Structs\Summary[] $summary
     * @param string $layerTypeName
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\BaseFare $baseFare = null, \Sabre\OTAAirPrice\Structs\ConstructedTotal $constructedTotal = null, \Sabre\OTAAirPrice\Structs\Equivalent $equivalent = null, \Sabre\OTAAirPrice\Structs\TotalTaxes $totalTaxes = null, \Sabre\OTAAirPrice\Structs\TotalPerPassenger $totalPerPassenger = null, \Sabre\OTAAirPrice\Structs\FareCalculation $fareCalculation = null, array $sellingFareTaxData = array(), array $sellingFareTaxBreakdown = array(), array $summary = array(), $layerTypeName = null)
    {
        $this
            ->setBaseFare($baseFare)
            ->setConstructedTotal($constructedTotal)
            ->setEquivalent($equivalent)
            ->setTotalTaxes($totalTaxes)
            ->setTotalPerPassenger($totalPerPassenger)
            ->setFareCalculation($fareCalculation)
            ->setSellingFareTaxData($sellingFareTaxData)
            ->setSellingFareTaxBreakdown($sellingFareTaxBreakdown)
            ->setSummary($summary)
            ->setLayerTypeName($layerTypeName);
    }
    /**
     * Get BaseFare value
     * @return \Sabre\OTAAirPrice\Structs\BaseFare|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \Sabre\OTAAirPrice\Structs\BaseFare $baseFare
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setBaseFare(\Sabre\OTAAirPrice\Structs\BaseFare $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get ConstructedTotal value
     * @return \Sabre\OTAAirPrice\Structs\ConstructedTotal|null
     */
    public function getConstructedTotal()
    {
        return $this->ConstructedTotal;
    }
    /**
     * Set ConstructedTotal value
     * @param \Sabre\OTAAirPrice\Structs\ConstructedTotal $constructedTotal
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setConstructedTotal(\Sabre\OTAAirPrice\Structs\ConstructedTotal $constructedTotal = null)
    {
        $this->ConstructedTotal = $constructedTotal;
        return $this;
    }
    /**
     * Get Equivalent value
     * @return \Sabre\OTAAirPrice\Structs\Equivalent|null
     */
    public function getEquivalent()
    {
        return $this->Equivalent;
    }
    /**
     * Set Equivalent value
     * @param \Sabre\OTAAirPrice\Structs\Equivalent $equivalent
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setEquivalent(\Sabre\OTAAirPrice\Structs\Equivalent $equivalent = null)
    {
        $this->Equivalent = $equivalent;
        return $this;
    }
    /**
     * Get TotalTaxes value
     * @return \Sabre\OTAAirPrice\Structs\TotalTaxes|null
     */
    public function getTotalTaxes()
    {
        return $this->TotalTaxes;
    }
    /**
     * Set TotalTaxes value
     * @param \Sabre\OTAAirPrice\Structs\TotalTaxes $totalTaxes
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setTotalTaxes(\Sabre\OTAAirPrice\Structs\TotalTaxes $totalTaxes = null)
    {
        $this->TotalTaxes = $totalTaxes;
        return $this;
    }
    /**
     * Get TotalPerPassenger value
     * @return \Sabre\OTAAirPrice\Structs\TotalPerPassenger|null
     */
    public function getTotalPerPassenger()
    {
        return $this->TotalPerPassenger;
    }
    /**
     * Set TotalPerPassenger value
     * @param \Sabre\OTAAirPrice\Structs\TotalPerPassenger $totalPerPassenger
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setTotalPerPassenger(\Sabre\OTAAirPrice\Structs\TotalPerPassenger $totalPerPassenger = null)
    {
        $this->TotalPerPassenger = $totalPerPassenger;
        return $this;
    }
    /**
     * Get FareCalculation value
     * @return \Sabre\OTAAirPrice\Structs\FareCalculation|null
     */
    public function getFareCalculation()
    {
        return $this->FareCalculation;
    }
    /**
     * Set FareCalculation value
     * @param \Sabre\OTAAirPrice\Structs\FareCalculation $fareCalculation
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setFareCalculation(\Sabre\OTAAirPrice\Structs\FareCalculation $fareCalculation = null)
    {
        $this->FareCalculation = $fareCalculation;
        return $this;
    }
    /**
     * Get SellingFareTaxData value
     * @return \Sabre\OTAAirPrice\Structs\SellingFareTaxData[]|null
     */
    public function getSellingFareTaxData()
    {
        return $this->SellingFareTaxData;
    }
    /**
     * Set SellingFareTaxData value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SellingFareTaxData[] $sellingFareTaxData
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setSellingFareTaxData(array $sellingFareTaxData = array())
    {
        $this->SellingFareTaxData = $sellingFareTaxData;
        return $this;
    }
    /**
     * Add item to SellingFareTaxData value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SellingFareTaxData $item
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function addToSellingFareTaxData(\Sabre\OTAAirPrice\Structs\SellingFareTaxData $item)
    {
        $this->SellingFareTaxData[] = $item;
        return $this;
    }
    /**
     * Get SellingFareTaxBreakdown value
     * @return \Sabre\OTAAirPrice\Structs\SellingFareTaxBreakdown[]|null
     */
    public function getSellingFareTaxBreakdown()
    {
        return $this->SellingFareTaxBreakdown;
    }
    /**
     * Set SellingFareTaxBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SellingFareTaxBreakdown[] $sellingFareTaxBreakdown
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setSellingFareTaxBreakdown(array $sellingFareTaxBreakdown = array())
    {
        $this->SellingFareTaxBreakdown = $sellingFareTaxBreakdown;
        return $this;
    }
    /**
     * Add item to SellingFareTaxBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SellingFareTaxBreakdown $item
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function addToSellingFareTaxBreakdown(\Sabre\OTAAirPrice\Structs\SellingFareTaxBreakdown $item)
    {
        $this->SellingFareTaxBreakdown[] = $item;
        return $this;
    }
    /**
     * Get Summary value
     * @return \Sabre\OTAAirPrice\Structs\Summary[]|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Summary[] $summary
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setSummary(array $summary = array())
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Add item to Summary value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Summary $item
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function addToSummary(\Sabre\OTAAirPrice\Structs\Summary $item)
    {
        $this->Summary[] = $item;
        return $this;
    }
    /**
     * Get LayerTypeName value
     * @return string|null
     */
    public function getLayerTypeName()
    {
        return $this->LayerTypeName;
    }
    /**
     * Set LayerTypeName value
     * @param string $layerTypeName
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public function setLayerTypeName($layerTypeName = null)
    {
        $this->LayerTypeName = $layerTypeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
