<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetailerRuleQualifier Structs
 * @subpackage Structs
 */
class RetailerRuleQualifier extends AbstractStructBase
{
    /**
     * The Qualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * @var string[]
     */
    public $Qualifier;
    /**
     * The Force
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Force;
    /**
     * Constructor method for RetailerRuleQualifier
     * @uses RetailerRuleQualifier::setQualifier()
     * @uses RetailerRuleQualifier::setForce()
     * @param string[] $qualifier
     * @param bool $force
     */
    public function __construct(array $qualifier = array(), $force = null)
    {
        $this
            ->setQualifier($qualifier)
            ->setForce($force);
    }
    /**
     * Get Qualifier value
     * @return string[]|null
     */
    public function getQualifier()
    {
        return $this->Qualifier;
    }
    /**
     * Set Qualifier value
     * @throws \InvalidArgumentException
     * @param string[] $qualifier
     * @return \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier
     */
    public function setQualifier(array $qualifier = array())
    {
        $this->Qualifier = $qualifier;
        return $this;
    }
    /**
     * Add item to Qualifier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier
     */
    public function addToQualifier($item)
    {
        $this->Qualifier[] = $item;
        return $this;
    }
    /**
     * Get Force value
     * @return bool|null
     */
    public function getForce()
    {
        return $this->Force;
    }
    /**
     * Set Force value
     * @param bool $force
     * @return \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier
     */
    public function setForce($force = null)
    {
        $this->Force = $force;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
