<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyInformation Structs
 * @subpackage Structs
 */
class PenaltyInformation extends AbstractStructBase
{
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FareBasisCode;
    /**
     * The FareComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FareComponent;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The Cat16
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Cat16;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Currency;
    /**
     * The NotApplicable
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $NotApplicable;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for PenaltyInformation
     * @uses PenaltyInformation::setFareBasisCode()
     * @uses PenaltyInformation::setFareComponent()
     * @uses PenaltyInformation::setAmount()
     * @uses PenaltyInformation::setCat16()
     * @uses PenaltyInformation::setCurrency()
     * @uses PenaltyInformation::setNotApplicable()
     * @uses PenaltyInformation::setType()
     * @param string[] $fareBasisCode
     * @param string[] $fareComponent
     * @param string $amount
     * @param bool $cat16
     * @param string $currency
     * @param bool $notApplicable
     * @param string $type
     */
    public function __construct(array $fareBasisCode = array(), array $fareComponent = array(), $amount = null, $cat16 = null, $currency = null, $notApplicable = null, $type = null)
    {
        $this
            ->setFareBasisCode($fareBasisCode)
            ->setFareComponent($fareComponent)
            ->setAmount($amount)
            ->setCat16($cat16)
            ->setCurrency($currency)
            ->setNotApplicable($notApplicable)
            ->setType($type);
    }
    /**
     * Get FareBasisCode value
     * @return string[]|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string[] $fareBasisCode
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function setFareBasisCode(array $fareBasisCode = array())
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Add item to FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function addToFareBasisCode($item)
    {
        $this->FareBasisCode[] = $item;
        return $this;
    }
    /**
     * Get FareComponent value
     * @return string[]|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * Set FareComponent value
     * @throws \InvalidArgumentException
     * @param string[] $fareComponent
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function setFareComponent(array $fareComponent = array())
    {
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Add item to FareComponent value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function addToFareComponent($item)
    {
        $this->FareComponent[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Cat16 value
     * @return bool|null
     */
    public function getCat16()
    {
        return $this->Cat16;
    }
    /**
     * Set Cat16 value
     * @param bool $cat16
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function setCat16($cat16 = null)
    {
        $this->Cat16 = $cat16;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get NotApplicable value
     * @return bool|null
     */
    public function getNotApplicable()
    {
        return $this->NotApplicable;
    }
    /**
     * Set NotApplicable value
     * @param bool $notApplicable
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function setNotApplicable($notApplicable = null)
    {
        $this->NotApplicable = $notApplicable;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\PenaltyInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
