<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayLaterPlan Structs
 * @subpackage Structs
 */
class PayLaterPlan extends AbstractStructBase
{
    /**
     * The Fare
     * @var \Sabre\OTAAirPrice\Structs\Fare
     */
    public $Fare;
    /**
     * The FOP
     * @var \Sabre\OTAAirPrice\Structs\FOP
     */
    public $FOP;
    /**
     * The Installment
     * @var \Sabre\OTAAirPrice\Structs\Installment
     */
    public $Installment;
    /**
     * Constructor method for PayLaterPlan
     * @uses PayLaterPlan::setFare()
     * @uses PayLaterPlan::setFOP()
     * @uses PayLaterPlan::setInstallment()
     * @param \Sabre\OTAAirPrice\Structs\Fare $fare
     * @param \Sabre\OTAAirPrice\Structs\FOP $fOP
     * @param \Sabre\OTAAirPrice\Structs\Installment $installment
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\Fare $fare = null, \Sabre\OTAAirPrice\Structs\FOP $fOP = null, \Sabre\OTAAirPrice\Structs\Installment $installment = null)
    {
        $this
            ->setFare($fare)
            ->setFOP($fOP)
            ->setInstallment($installment);
    }
    /**
     * Get Fare value
     * @return \Sabre\OTAAirPrice\Structs\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \Sabre\OTAAirPrice\Structs\Fare $fare
     * @return \Sabre\OTAAirPrice\Structs\PayLaterPlan
     */
    public function setFare(\Sabre\OTAAirPrice\Structs\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get FOP value
     * @return \Sabre\OTAAirPrice\Structs\FOP|null
     */
    public function getFOP()
    {
        return $this->FOP;
    }
    /**
     * Set FOP value
     * @param \Sabre\OTAAirPrice\Structs\FOP $fOP
     * @return \Sabre\OTAAirPrice\Structs\PayLaterPlan
     */
    public function setFOP(\Sabre\OTAAirPrice\Structs\FOP $fOP = null)
    {
        $this->FOP = $fOP;
        return $this;
    }
    /**
     * Get Installment value
     * @return \Sabre\OTAAirPrice\Structs\Installment|null
     */
    public function getInstallment()
    {
        return $this->Installment;
    }
    /**
     * Set Installment value
     * @param \Sabre\OTAAirPrice\Structs\Installment $installment
     * @return \Sabre\OTAAirPrice\Structs\PayLaterPlan
     */
    public function setInstallment(\Sabre\OTAAirPrice\Structs\Installment $installment = null)
    {
        $this->Installment = $installment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\PayLaterPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
