<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryInfo Structs
 * @subpackage Structs
 */
class ItineraryInfo extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The BookingMethodReq
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BookingMethodReq;
    /**
     * The SegmentCount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SegmentCount;
    /**
     * Constructor method for ItineraryInfo
     * @uses ItineraryInfo::setFlightSegment()
     * @uses ItineraryInfo::setBookingMethodReq()
     * @uses ItineraryInfo::setSegmentCount()
     * @param \Sabre\OTAAirPrice\Structs\FlightSegment[] $flightSegment
     * @param string $bookingMethodReq
     * @param string $segmentCount
     */
    public function __construct(array $flightSegment = array(), $bookingMethodReq = null, $segmentCount = null)
    {
        $this
            ->setFlightSegment($flightSegment)
            ->setBookingMethodReq($bookingMethodReq)
            ->setSegmentCount($segmentCount);
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\OTAAirPrice\Structs\ItineraryInfo
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\FlightSegment $item
     * @return \Sabre\OTAAirPrice\Structs\ItineraryInfo
     */
    public function addToFlightSegment(\Sabre\OTAAirPrice\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get BookingMethodReq value
     * @return string|null
     */
    public function getBookingMethodReq()
    {
        return $this->BookingMethodReq;
    }
    /**
     * Set BookingMethodReq value
     * @param string $bookingMethodReq
     * @return \Sabre\OTAAirPrice\Structs\ItineraryInfo
     */
    public function setBookingMethodReq($bookingMethodReq = null)
    {
        $this->BookingMethodReq = $bookingMethodReq;
        return $this;
    }
    /**
     * Get SegmentCount value
     * @return string|null
     */
    public function getSegmentCount()
    {
        return $this->SegmentCount;
    }
    /**
     * Set SegmentCount value
     * @param string $segmentCount
     * @return \Sabre\OTAAirPrice\Structs\ItineraryInfo
     */
    public function setSegmentCount($segmentCount = null)
    {
        $this->SegmentCount = $segmentCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\ItineraryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
