<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment Structs
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The MarketingCarrier
     * @var \Sabre\OTAAirPrice\Structs\MarketingCarrier
     */
    public $MarketingCarrier;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The ConnectionInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConnectionInd;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\MarketingAirline
     */
    public $MarketingAirline;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setDestinationLocation()
     * @uses FlightSegment::setMarketingCarrier()
     * @uses FlightSegment::setOriginLocation()
     * @uses FlightSegment::setArrivalDateTime()
     * @uses FlightSegment::setConnectionInd()
     * @uses FlightSegment::setDepartureDateTime()
     * @uses FlightSegment::setFlightNumber()
     * @uses FlightSegment::setResBookDesigCode()
     * @uses FlightSegment::setRPH()
     * @uses FlightSegment::setMarketingAirline()
     * @uses FlightSegment::setSegmentNumber()
     * @uses FlightSegment::setStatus()
     * @param \Sabre\OTAAirPrice\Structs\DestinationLocation $destinationLocation
     * @param \Sabre\OTAAirPrice\Structs\MarketingCarrier $marketingCarrier
     * @param \Sabre\OTAAirPrice\Structs\OriginLocation $originLocation
     * @param string $arrivalDateTime
     * @param string $connectionInd
     * @param string $departureDateTime
     * @param string $flightNumber
     * @param string $resBookDesigCode
     * @param string $rPH
     * @param \Sabre\OTAAirPrice\Structs\MarketingAirline $marketingAirline
     * @param string $segmentNumber
     * @param string $status
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\DestinationLocation $destinationLocation = null, \Sabre\OTAAirPrice\Structs\MarketingCarrier $marketingCarrier = null, \Sabre\OTAAirPrice\Structs\OriginLocation $originLocation = null, $arrivalDateTime = null, $connectionInd = null, $departureDateTime = null, $flightNumber = null, $resBookDesigCode = null, $rPH = null, \Sabre\OTAAirPrice\Structs\MarketingAirline $marketingAirline = null, $segmentNumber = null, $status = null)
    {
        $this
            ->setDestinationLocation($destinationLocation)
            ->setMarketingCarrier($marketingCarrier)
            ->setOriginLocation($originLocation)
            ->setArrivalDateTime($arrivalDateTime)
            ->setConnectionInd($connectionInd)
            ->setDepartureDateTime($departureDateTime)
            ->setFlightNumber($flightNumber)
            ->setResBookDesigCode($resBookDesigCode)
            ->setRPH($rPH)
            ->setMarketingAirline($marketingAirline)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status);
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\OTAAirPrice\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\OTAAirPrice\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setDestinationLocation(\Sabre\OTAAirPrice\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get MarketingCarrier value
     * @return \Sabre\OTAAirPrice\Structs\MarketingCarrier|null
     */
    public function getMarketingCarrier()
    {
        return $this->MarketingCarrier;
    }
    /**
     * Set MarketingCarrier value
     * @param \Sabre\OTAAirPrice\Structs\MarketingCarrier $marketingCarrier
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setMarketingCarrier(\Sabre\OTAAirPrice\Structs\MarketingCarrier $marketingCarrier = null)
    {
        $this->MarketingCarrier = $marketingCarrier;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\OTAAirPrice\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\OTAAirPrice\Structs\OriginLocation $originLocation
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setOriginLocation(\Sabre\OTAAirPrice\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get ConnectionInd value
     * @return string|null
     */
    public function getConnectionInd()
    {
        return $this->ConnectionInd;
    }
    /**
     * Set ConnectionInd value
     * @param string $connectionInd
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setConnectionInd($connectionInd = null)
    {
        $this->ConnectionInd = $connectionInd;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \Sabre\OTAAirPrice\Structs\MarketingAirline|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \Sabre\OTAAirPrice\Structs\MarketingAirline $marketingAirline
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setMarketingAirline(\Sabre\OTAAirPrice\Structs\MarketingAirline $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
