<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BargainFinder Structs
 * @subpackage Structs
 */
class BargainFinder extends AbstractStructBase
{
    /**
     * The Historical
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Historical;
    /**
     * The Rebook
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Rebook;
    /**
     * The AlternateBooking
     * Meta informations extracted from the WSDL
     * - maxOccurs: 24
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\AlternateBooking[]
     */
    public $AlternateBooking;
    /**
     * Constructor method for BargainFinder
     * @uses BargainFinder::setHistorical()
     * @uses BargainFinder::setRebook()
     * @uses BargainFinder::setAlternateBooking()
     * @param bool $historical
     * @param bool $rebook
     * @param \Sabre\OTAAirPrice\Structs\AlternateBooking[] $alternateBooking
     */
    public function __construct($historical = null, $rebook = null, array $alternateBooking = array())
    {
        $this
            ->setHistorical($historical)
            ->setRebook($rebook)
            ->setAlternateBooking($alternateBooking);
    }
    /**
     * Get Historical value
     * @return bool|null
     */
    public function getHistorical()
    {
        return $this->Historical;
    }
    /**
     * Set Historical value
     * @param bool $historical
     * @return \Sabre\OTAAirPrice\Structs\BargainFinder
     */
    public function setHistorical($historical = null)
    {
        $this->Historical = $historical;
        return $this;
    }
    /**
     * Get Rebook value
     * @return bool|null
     */
    public function getRebook()
    {
        return $this->Rebook;
    }
    /**
     * Set Rebook value
     * @param bool $rebook
     * @return \Sabre\OTAAirPrice\Structs\BargainFinder
     */
    public function setRebook($rebook = null)
    {
        $this->Rebook = $rebook;
        return $this;
    }
    /**
     * Get AlternateBooking value
     * @return \Sabre\OTAAirPrice\Structs\AlternateBooking[]|null
     */
    public function getAlternateBooking()
    {
        return $this->AlternateBooking;
    }
    /**
     * Set AlternateBooking value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\AlternateBooking[] $alternateBooking
     * @return \Sabre\OTAAirPrice\Structs\BargainFinder
     */
    public function setAlternateBooking(array $alternateBooking = array())
    {
        $this->AlternateBooking = $alternateBooking;
        return $this;
    }
    /**
     * Add item to AlternateBooking value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\AlternateBooking $item
     * @return \Sabre\OTAAirPrice\Structs\BargainFinder
     */
    public function addToAlternateBooking(\Sabre\OTAAirPrice\Structs\AlternateBooking $item)
    {
        $this->AlternateBooking[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\BargainFinder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
