<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatingCarrier Structs
 * @subpackage Structs
 */
class ValidatingCarrier extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The SettlementMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SettlementMethod;
    /**
     * The IETCheckedValidatingCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 24
     * - minOccurs: 0
     * @var string[]
     */
    public $IETCheckedValidatingCarrier;
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Ticket[]
     */
    public $Ticket;
    /**
     * The NewValidatingProcess
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $NewValidatingProcess;
    /**
     * The SolutionSequenceNmbr
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SolutionSequenceNmbr;
    /**
     * Constructor method for ValidatingCarrier
     * @uses ValidatingCarrier::setCode()
     * @uses ValidatingCarrier::setSettlementMethod()
     * @uses ValidatingCarrier::setIETCheckedValidatingCarrier()
     * @uses ValidatingCarrier::setTicket()
     * @uses ValidatingCarrier::setNewValidatingProcess()
     * @uses ValidatingCarrier::setSolutionSequenceNmbr()
     * @param string $code
     * @param string $settlementMethod
     * @param string[] $iETCheckedValidatingCarrier
     * @param \Sabre\OTAAirPrice\Structs\Ticket[] $ticket
     * @param bool $newValidatingProcess
     * @param string $solutionSequenceNmbr
     */
    public function __construct($code = null, $settlementMethod = null, array $iETCheckedValidatingCarrier = array(), array $ticket = array(), $newValidatingProcess = null, $solutionSequenceNmbr = null)
    {
        $this
            ->setCode($code)
            ->setSettlementMethod($settlementMethod)
            ->setIETCheckedValidatingCarrier($iETCheckedValidatingCarrier)
            ->setTicket($ticket)
            ->setNewValidatingProcess($newValidatingProcess)
            ->setSolutionSequenceNmbr($solutionSequenceNmbr);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get SettlementMethod value
     * @return string|null
     */
    public function getSettlementMethod()
    {
        return $this->SettlementMethod;
    }
    /**
     * Set SettlementMethod value
     * @param string $settlementMethod
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public function setSettlementMethod($settlementMethod = null)
    {
        $this->SettlementMethod = $settlementMethod;
        return $this;
    }
    /**
     * Get IETCheckedValidatingCarrier value
     * @return string[]|null
     */
    public function getIETCheckedValidatingCarrier()
    {
        return $this->IETCheckedValidatingCarrier;
    }
    /**
     * Set IETCheckedValidatingCarrier value
     * @throws \InvalidArgumentException
     * @param string[] $iETCheckedValidatingCarrier
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public function setIETCheckedValidatingCarrier(array $iETCheckedValidatingCarrier = array())
    {
        $this->IETCheckedValidatingCarrier = $iETCheckedValidatingCarrier;
        return $this;
    }
    /**
     * Add item to IETCheckedValidatingCarrier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public function addToIETCheckedValidatingCarrier($item)
    {
        $this->IETCheckedValidatingCarrier[] = $item;
        return $this;
    }
    /**
     * Get Ticket value
     * @return \Sabre\OTAAirPrice\Structs\Ticket[]|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Ticket[] $ticket
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public function setTicket(array $ticket = array())
    {
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Add item to Ticket value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Ticket $item
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public function addToTicket(\Sabre\OTAAirPrice\Structs\Ticket $item)
    {
        $this->Ticket[] = $item;
        return $this;
    }
    /**
     * Get NewValidatingProcess value
     * @return bool|null
     */
    public function getNewValidatingProcess()
    {
        return $this->NewValidatingProcess;
    }
    /**
     * Set NewValidatingProcess value
     * @param bool $newValidatingProcess
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public function setNewValidatingProcess($newValidatingProcess = null)
    {
        $this->NewValidatingProcess = $newValidatingProcess;
        return $this;
    }
    /**
     * Get SolutionSequenceNmbr value
     * @return string|null
     */
    public function getSolutionSequenceNmbr()
    {
        return $this->SolutionSequenceNmbr;
    }
    /**
     * Set SolutionSequenceNmbr value
     * @param string $solutionSequenceNmbr
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public function setSolutionSequenceNmbr($solutionSequenceNmbr = null)
    {
        $this->SolutionSequenceNmbr = $solutionSequenceNmbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
