<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxes Structs
 * @subpackage Structs
 */
class Taxes extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Tax[]
     */
    public $Tax;
    /**
     * The NoTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\NoTax
     */
    public $NoTax;
    /**
     * The TaxExempt
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\TaxExempt[]
     */
    public $TaxExempt;
    /**
     * The TaxOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\TaxOverride[]
     */
    public $TaxOverride;
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Ind;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TotalAmount;
    /**
     * Constructor method for Taxes
     * @uses Taxes::setTax()
     * @uses Taxes::setNoTax()
     * @uses Taxes::setTaxExempt()
     * @uses Taxes::setTaxOverride()
     * @uses Taxes::setInd()
     * @uses Taxes::setTotalAmount()
     * @param \Sabre\OTAAirPrice\Structs\Tax[] $tax
     * @param \Sabre\OTAAirPrice\Structs\NoTax $noTax
     * @param \Sabre\OTAAirPrice\Structs\TaxExempt[] $taxExempt
     * @param \Sabre\OTAAirPrice\Structs\TaxOverride[] $taxOverride
     * @param string $ind
     * @param string $totalAmount
     */
    public function __construct(array $tax = array(), \Sabre\OTAAirPrice\Structs\NoTax $noTax = null, array $taxExempt = array(), array $taxOverride = array(), $ind = null, $totalAmount = null)
    {
        $this
            ->setTax($tax)
            ->setNoTax($noTax)
            ->setTaxExempt($taxExempt)
            ->setTaxOverride($taxOverride)
            ->setInd($ind)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get Tax value
     * @return \Sabre\OTAAirPrice\Structs\Tax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Tax[] $tax
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Tax $item
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function addToTax(\Sabre\OTAAirPrice\Structs\Tax $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get NoTax value
     * @return \Sabre\OTAAirPrice\Structs\NoTax|null
     */
    public function getNoTax()
    {
        return $this->NoTax;
    }
    /**
     * Set NoTax value
     * @param \Sabre\OTAAirPrice\Structs\NoTax $noTax
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function setNoTax(\Sabre\OTAAirPrice\Structs\NoTax $noTax = null)
    {
        $this->NoTax = $noTax;
        return $this;
    }
    /**
     * Get TaxExempt value
     * @return \Sabre\OTAAirPrice\Structs\TaxExempt[]|null
     */
    public function getTaxExempt()
    {
        return $this->TaxExempt;
    }
    /**
     * Set TaxExempt value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\TaxExempt[] $taxExempt
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function setTaxExempt(array $taxExempt = array())
    {
        $this->TaxExempt = $taxExempt;
        return $this;
    }
    /**
     * Add item to TaxExempt value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\TaxExempt $item
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function addToTaxExempt(\Sabre\OTAAirPrice\Structs\TaxExempt $item)
    {
        $this->TaxExempt[] = $item;
        return $this;
    }
    /**
     * Get TaxOverride value
     * @return \Sabre\OTAAirPrice\Structs\TaxOverride[]|null
     */
    public function getTaxOverride()
    {
        return $this->TaxOverride;
    }
    /**
     * Set TaxOverride value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\TaxOverride[] $taxOverride
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function setTaxOverride(array $taxOverride = array())
    {
        $this->TaxOverride = $taxOverride;
        return $this;
    }
    /**
     * Add item to TaxOverride value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\TaxOverride $item
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function addToTaxOverride(\Sabre\OTAAirPrice\Structs\TaxOverride $item)
    {
        $this->TaxOverride[] = $item;
        return $this;
    }
    /**
     * Get Ind value
     * @return string|null
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param string $ind
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\Taxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
