<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingQualifiers Structs
 * @subpackage Structs
 */
class PricingQualifiers extends AbstractStructBase
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Account
     */
    public $Account;
    /**
     * The AlternativePricing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\AlternativePricing
     */
    public $AlternativePricing;
    /**
     * The BankersSellingRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BankersSellingRate;
    /**
     * The BargainFinder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\BargainFinder
     */
    public $BargainFinder;
    /**
     * The BasicEconomyExclude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var string[]
     */
    public $BasicEconomyExclude;
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Brand[]
     */
    public $Brand;
    /**
     * The BuyingDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $BuyingDate;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Cabin;
    /**
     * The CommandPricing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\CommandPricing[]
     */
    public $CommandPricing;
    /**
     * The CommissionContract
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var string[]
     */
    public $CommissionContract;
    /**
     * The Corporate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Corporate
     */
    public $Corporate;
    /**
     * The Fare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Fare
     */
    public $Fare;
    /**
     * The FareOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\FareOptions
     */
    public $FareOptions;
    /**
     * The ItineraryOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ItineraryOptions
     */
    public $ItineraryOptions;
    /**
     * The ManuallyAdjustedSellingLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ManuallyAdjustedSellingLevel[]
     */
    public $ManuallyAdjustedSellingLevel;
    /**
     * The NameSelect
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\NameSelect[]
     */
    public $NameSelect;
    /**
     * The NetRemit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\NetRemit
     */
    public $NetRemit;
    /**
     * The Overrides
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Overrides
     */
    public $Overrides;
    /**
     * The PassengerStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PassengerStatus;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\PassengerType[]
     */
    public $PassengerType;
    /**
     * The PlusUp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\PlusUp
     */
    public $PlusUp;
    /**
     * The RetailerRuleQualifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier
     */
    public $RetailerRuleQualifier;
    /**
     * The ShipsRegistry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipsRegistry;
    /**
     * The SpanishLargeFamilyDiscountLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpanishLargeFamilyDiscountLevel;
    /**
     * The SpecificFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\SpecificFare[]
     */
    public $SpecificFare;
    /**
     * The SpecificPenalty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\SpecificPenalty
     */
    public $SpecificPenalty;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Taxes
     */
    public $Taxes;
    /**
     * The ValidityDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ValidityDates[]
     */
    public $ValidityDates;
    /**
     * The AlternateCurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AlternateCurrencyCode;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The AggregatedContentExclude
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $AggregatedContentExclude;
    /**
     * The FareFocusExclude
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $FareFocusExclude;
    /**
     * The NoDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $NoDate;
    /**
     * The RoundTheWorld
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $RoundTheWorld;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Source;
    /**
     * Constructor method for PricingQualifiers
     * @uses PricingQualifiers::setAccount()
     * @uses PricingQualifiers::setAlternativePricing()
     * @uses PricingQualifiers::setBankersSellingRate()
     * @uses PricingQualifiers::setBargainFinder()
     * @uses PricingQualifiers::setBasicEconomyExclude()
     * @uses PricingQualifiers::setBrand()
     * @uses PricingQualifiers::setBuyingDate()
     * @uses PricingQualifiers::setCabin()
     * @uses PricingQualifiers::setCommandPricing()
     * @uses PricingQualifiers::setCommissionContract()
     * @uses PricingQualifiers::setCorporate()
     * @uses PricingQualifiers::setFare()
     * @uses PricingQualifiers::setFareOptions()
     * @uses PricingQualifiers::setItineraryOptions()
     * @uses PricingQualifiers::setManuallyAdjustedSellingLevel()
     * @uses PricingQualifiers::setNameSelect()
     * @uses PricingQualifiers::setNetRemit()
     * @uses PricingQualifiers::setOverrides()
     * @uses PricingQualifiers::setPassengerStatus()
     * @uses PricingQualifiers::setPassengerType()
     * @uses PricingQualifiers::setPlusUp()
     * @uses PricingQualifiers::setRetailerRuleQualifier()
     * @uses PricingQualifiers::setShipsRegistry()
     * @uses PricingQualifiers::setSpanishLargeFamilyDiscountLevel()
     * @uses PricingQualifiers::setSpecificFare()
     * @uses PricingQualifiers::setSpecificPenalty()
     * @uses PricingQualifiers::setTaxes()
     * @uses PricingQualifiers::setValidityDates()
     * @uses PricingQualifiers::setAlternateCurrencyCode()
     * @uses PricingQualifiers::setCurrencyCode()
     * @uses PricingQualifiers::setAggregatedContentExclude()
     * @uses PricingQualifiers::setFareFocusExclude()
     * @uses PricingQualifiers::setNoDate()
     * @uses PricingQualifiers::setRoundTheWorld()
     * @uses PricingQualifiers::setSource()
     * @param \Sabre\OTAAirPrice\Structs\Account $account
     * @param \Sabre\OTAAirPrice\Structs\AlternativePricing $alternativePricing
     * @param string $bankersSellingRate
     * @param \Sabre\OTAAirPrice\Structs\BargainFinder $bargainFinder
     * @param string[] $basicEconomyExclude
     * @param \Sabre\OTAAirPrice\Structs\Brand[] $brand
     * @param string $buyingDate
     * @param string $cabin
     * @param \Sabre\OTAAirPrice\Structs\CommandPricing[] $commandPricing
     * @param string[] $commissionContract
     * @param \Sabre\OTAAirPrice\Structs\Corporate $corporate
     * @param \Sabre\OTAAirPrice\Structs\Fare $fare
     * @param \Sabre\OTAAirPrice\Structs\FareOptions $fareOptions
     * @param \Sabre\OTAAirPrice\Structs\ItineraryOptions $itineraryOptions
     * @param \Sabre\OTAAirPrice\Structs\ManuallyAdjustedSellingLevel[] $manuallyAdjustedSellingLevel
     * @param \Sabre\OTAAirPrice\Structs\NameSelect[] $nameSelect
     * @param \Sabre\OTAAirPrice\Structs\NetRemit $netRemit
     * @param \Sabre\OTAAirPrice\Structs\Overrides $overrides
     * @param string $passengerStatus
     * @param \Sabre\OTAAirPrice\Structs\PassengerType[] $passengerType
     * @param \Sabre\OTAAirPrice\Structs\PlusUp $plusUp
     * @param \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier $retailerRuleQualifier
     * @param string $shipsRegistry
     * @param string $spanishLargeFamilyDiscountLevel
     * @param \Sabre\OTAAirPrice\Structs\SpecificFare[] $specificFare
     * @param \Sabre\OTAAirPrice\Structs\SpecificPenalty $specificPenalty
     * @param \Sabre\OTAAirPrice\Structs\Taxes $taxes
     * @param \Sabre\OTAAirPrice\Structs\ValidityDates[] $validityDates
     * @param string $alternateCurrencyCode
     * @param string $currencyCode
     * @param bool $aggregatedContentExclude
     * @param bool $fareFocusExclude
     * @param bool $noDate
     * @param bool $roundTheWorld
     * @param string $source
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\Account $account = null, \Sabre\OTAAirPrice\Structs\AlternativePricing $alternativePricing = null, $bankersSellingRate = null, \Sabre\OTAAirPrice\Structs\BargainFinder $bargainFinder = null, array $basicEconomyExclude = array(), array $brand = array(), $buyingDate = null, $cabin = null, array $commandPricing = array(), array $commissionContract = array(), \Sabre\OTAAirPrice\Structs\Corporate $corporate = null, \Sabre\OTAAirPrice\Structs\Fare $fare = null, \Sabre\OTAAirPrice\Structs\FareOptions $fareOptions = null, \Sabre\OTAAirPrice\Structs\ItineraryOptions $itineraryOptions = null, array $manuallyAdjustedSellingLevel = array(), array $nameSelect = array(), \Sabre\OTAAirPrice\Structs\NetRemit $netRemit = null, \Sabre\OTAAirPrice\Structs\Overrides $overrides = null, $passengerStatus = null, array $passengerType = array(), \Sabre\OTAAirPrice\Structs\PlusUp $plusUp = null, \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier $retailerRuleQualifier = null, $shipsRegistry = null, $spanishLargeFamilyDiscountLevel = null, array $specificFare = array(), \Sabre\OTAAirPrice\Structs\SpecificPenalty $specificPenalty = null, \Sabre\OTAAirPrice\Structs\Taxes $taxes = null, array $validityDates = array(), $alternateCurrencyCode = null, $currencyCode = null, $aggregatedContentExclude = null, $fareFocusExclude = null, $noDate = null, $roundTheWorld = null, $source = null)
    {
        $this
            ->setAccount($account)
            ->setAlternativePricing($alternativePricing)
            ->setBankersSellingRate($bankersSellingRate)
            ->setBargainFinder($bargainFinder)
            ->setBasicEconomyExclude($basicEconomyExclude)
            ->setBrand($brand)
            ->setBuyingDate($buyingDate)
            ->setCabin($cabin)
            ->setCommandPricing($commandPricing)
            ->setCommissionContract($commissionContract)
            ->setCorporate($corporate)
            ->setFare($fare)
            ->setFareOptions($fareOptions)
            ->setItineraryOptions($itineraryOptions)
            ->setManuallyAdjustedSellingLevel($manuallyAdjustedSellingLevel)
            ->setNameSelect($nameSelect)
            ->setNetRemit($netRemit)
            ->setOverrides($overrides)
            ->setPassengerStatus($passengerStatus)
            ->setPassengerType($passengerType)
            ->setPlusUp($plusUp)
            ->setRetailerRuleQualifier($retailerRuleQualifier)
            ->setShipsRegistry($shipsRegistry)
            ->setSpanishLargeFamilyDiscountLevel($spanishLargeFamilyDiscountLevel)
            ->setSpecificFare($specificFare)
            ->setSpecificPenalty($specificPenalty)
            ->setTaxes($taxes)
            ->setValidityDates($validityDates)
            ->setAlternateCurrencyCode($alternateCurrencyCode)
            ->setCurrencyCode($currencyCode)
            ->setAggregatedContentExclude($aggregatedContentExclude)
            ->setFareFocusExclude($fareFocusExclude)
            ->setNoDate($noDate)
            ->setRoundTheWorld($roundTheWorld)
            ->setSource($source);
    }
    /**
     * Get Account value
     * @return \Sabre\OTAAirPrice\Structs\Account|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \Sabre\OTAAirPrice\Structs\Account $account
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setAccount(\Sabre\OTAAirPrice\Structs\Account $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AlternativePricing value
     * @return \Sabre\OTAAirPrice\Structs\AlternativePricing|null
     */
    public function getAlternativePricing()
    {
        return $this->AlternativePricing;
    }
    /**
     * Set AlternativePricing value
     * @param \Sabre\OTAAirPrice\Structs\AlternativePricing $alternativePricing
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setAlternativePricing(\Sabre\OTAAirPrice\Structs\AlternativePricing $alternativePricing = null)
    {
        $this->AlternativePricing = $alternativePricing;
        return $this;
    }
    /**
     * Get BankersSellingRate value
     * @return string|null
     */
    public function getBankersSellingRate()
    {
        return $this->BankersSellingRate;
    }
    /**
     * Set BankersSellingRate value
     * @param string $bankersSellingRate
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setBankersSellingRate($bankersSellingRate = null)
    {
        $this->BankersSellingRate = $bankersSellingRate;
        return $this;
    }
    /**
     * Get BargainFinder value
     * @return \Sabre\OTAAirPrice\Structs\BargainFinder|null
     */
    public function getBargainFinder()
    {
        return $this->BargainFinder;
    }
    /**
     * Set BargainFinder value
     * @param \Sabre\OTAAirPrice\Structs\BargainFinder $bargainFinder
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setBargainFinder(\Sabre\OTAAirPrice\Structs\BargainFinder $bargainFinder = null)
    {
        $this->BargainFinder = $bargainFinder;
        return $this;
    }
    /**
     * Get BasicEconomyExclude value
     * @return string[]|null
     */
    public function getBasicEconomyExclude()
    {
        return $this->BasicEconomyExclude;
    }
    /**
     * Set BasicEconomyExclude value
     * @throws \InvalidArgumentException
     * @param string[] $basicEconomyExclude
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setBasicEconomyExclude(array $basicEconomyExclude = array())
    {
        $this->BasicEconomyExclude = $basicEconomyExclude;
        return $this;
    }
    /**
     * Add item to BasicEconomyExclude value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToBasicEconomyExclude($item)
    {
        $this->BasicEconomyExclude[] = $item;
        return $this;
    }
    /**
     * Get Brand value
     * @return \Sabre\OTAAirPrice\Structs\Brand[]|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Brand[] $brand
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setBrand(array $brand = array())
    {
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Add item to Brand value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Brand $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToBrand(\Sabre\OTAAirPrice\Structs\Brand $item)
    {
        $this->Brand[] = $item;
        return $this;
    }
    /**
     * Get BuyingDate value
     * @return string|null
     */
    public function getBuyingDate()
    {
        return $this->BuyingDate;
    }
    /**
     * Set BuyingDate value
     * @param string $buyingDate
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setBuyingDate($buyingDate = null)
    {
        $this->BuyingDate = $buyingDate;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setCabin($cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get CommandPricing value
     * @return \Sabre\OTAAirPrice\Structs\CommandPricing[]|null
     */
    public function getCommandPricing()
    {
        return $this->CommandPricing;
    }
    /**
     * Set CommandPricing value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\CommandPricing[] $commandPricing
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setCommandPricing(array $commandPricing = array())
    {
        $this->CommandPricing = $commandPricing;
        return $this;
    }
    /**
     * Add item to CommandPricing value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\CommandPricing $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToCommandPricing(\Sabre\OTAAirPrice\Structs\CommandPricing $item)
    {
        $this->CommandPricing[] = $item;
        return $this;
    }
    /**
     * Get CommissionContract value
     * @return string[]|null
     */
    public function getCommissionContract()
    {
        return $this->CommissionContract;
    }
    /**
     * Set CommissionContract value
     * @throws \InvalidArgumentException
     * @param string[] $commissionContract
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setCommissionContract(array $commissionContract = array())
    {
        $this->CommissionContract = $commissionContract;
        return $this;
    }
    /**
     * Add item to CommissionContract value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToCommissionContract($item)
    {
        $this->CommissionContract[] = $item;
        return $this;
    }
    /**
     * Get Corporate value
     * @return \Sabre\OTAAirPrice\Structs\Corporate|null
     */
    public function getCorporate()
    {
        return $this->Corporate;
    }
    /**
     * Set Corporate value
     * @param \Sabre\OTAAirPrice\Structs\Corporate $corporate
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setCorporate(\Sabre\OTAAirPrice\Structs\Corporate $corporate = null)
    {
        $this->Corporate = $corporate;
        return $this;
    }
    /**
     * Get Fare value
     * @return \Sabre\OTAAirPrice\Structs\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \Sabre\OTAAirPrice\Structs\Fare $fare
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setFare(\Sabre\OTAAirPrice\Structs\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get FareOptions value
     * @return \Sabre\OTAAirPrice\Structs\FareOptions|null
     */
    public function getFareOptions()
    {
        return $this->FareOptions;
    }
    /**
     * Set FareOptions value
     * @param \Sabre\OTAAirPrice\Structs\FareOptions $fareOptions
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setFareOptions(\Sabre\OTAAirPrice\Structs\FareOptions $fareOptions = null)
    {
        $this->FareOptions = $fareOptions;
        return $this;
    }
    /**
     * Get ItineraryOptions value
     * @return \Sabre\OTAAirPrice\Structs\ItineraryOptions|null
     */
    public function getItineraryOptions()
    {
        return $this->ItineraryOptions;
    }
    /**
     * Set ItineraryOptions value
     * @param \Sabre\OTAAirPrice\Structs\ItineraryOptions $itineraryOptions
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setItineraryOptions(\Sabre\OTAAirPrice\Structs\ItineraryOptions $itineraryOptions = null)
    {
        $this->ItineraryOptions = $itineraryOptions;
        return $this;
    }
    /**
     * Get ManuallyAdjustedSellingLevel value
     * @return \Sabre\OTAAirPrice\Structs\ManuallyAdjustedSellingLevel[]|null
     */
    public function getManuallyAdjustedSellingLevel()
    {
        return $this->ManuallyAdjustedSellingLevel;
    }
    /**
     * Set ManuallyAdjustedSellingLevel value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ManuallyAdjustedSellingLevel[] $manuallyAdjustedSellingLevel
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setManuallyAdjustedSellingLevel(array $manuallyAdjustedSellingLevel = array())
    {
        $this->ManuallyAdjustedSellingLevel = $manuallyAdjustedSellingLevel;
        return $this;
    }
    /**
     * Add item to ManuallyAdjustedSellingLevel value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ManuallyAdjustedSellingLevel $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToManuallyAdjustedSellingLevel(\Sabre\OTAAirPrice\Structs\ManuallyAdjustedSellingLevel $item)
    {
        $this->ManuallyAdjustedSellingLevel[] = $item;
        return $this;
    }
    /**
     * Get NameSelect value
     * @return \Sabre\OTAAirPrice\Structs\NameSelect[]|null
     */
    public function getNameSelect()
    {
        return $this->NameSelect;
    }
    /**
     * Set NameSelect value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\NameSelect[] $nameSelect
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setNameSelect(array $nameSelect = array())
    {
        $this->NameSelect = $nameSelect;
        return $this;
    }
    /**
     * Add item to NameSelect value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\NameSelect $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToNameSelect(\Sabre\OTAAirPrice\Structs\NameSelect $item)
    {
        $this->NameSelect[] = $item;
        return $this;
    }
    /**
     * Get NetRemit value
     * @return \Sabre\OTAAirPrice\Structs\NetRemit|null
     */
    public function getNetRemit()
    {
        return $this->NetRemit;
    }
    /**
     * Set NetRemit value
     * @param \Sabre\OTAAirPrice\Structs\NetRemit $netRemit
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setNetRemit(\Sabre\OTAAirPrice\Structs\NetRemit $netRemit = null)
    {
        $this->NetRemit = $netRemit;
        return $this;
    }
    /**
     * Get Overrides value
     * @return \Sabre\OTAAirPrice\Structs\Overrides|null
     */
    public function getOverrides()
    {
        return $this->Overrides;
    }
    /**
     * Set Overrides value
     * @param \Sabre\OTAAirPrice\Structs\Overrides $overrides
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setOverrides(\Sabre\OTAAirPrice\Structs\Overrides $overrides = null)
    {
        $this->Overrides = $overrides;
        return $this;
    }
    /**
     * Get PassengerStatus value
     * @return string|null
     */
    public function getPassengerStatus()
    {
        return $this->PassengerStatus;
    }
    /**
     * Set PassengerStatus value
     * @param string $passengerStatus
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setPassengerStatus($passengerStatus = null)
    {
        $this->PassengerStatus = $passengerStatus;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return \Sabre\OTAAirPrice\Structs\PassengerType[]|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\PassengerType[] $passengerType
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setPassengerType(array $passengerType = array())
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Add item to PassengerType value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\PassengerType $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToPassengerType(\Sabre\OTAAirPrice\Structs\PassengerType $item)
    {
        $this->PassengerType[] = $item;
        return $this;
    }
    /**
     * Get PlusUp value
     * @return \Sabre\OTAAirPrice\Structs\PlusUp|null
     */
    public function getPlusUp()
    {
        return $this->PlusUp;
    }
    /**
     * Set PlusUp value
     * @param \Sabre\OTAAirPrice\Structs\PlusUp $plusUp
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setPlusUp(\Sabre\OTAAirPrice\Structs\PlusUp $plusUp = null)
    {
        $this->PlusUp = $plusUp;
        return $this;
    }
    /**
     * Get RetailerRuleQualifier value
     * @return \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier|null
     */
    public function getRetailerRuleQualifier()
    {
        return $this->RetailerRuleQualifier;
    }
    /**
     * Set RetailerRuleQualifier value
     * @param \Sabre\OTAAirPrice\Structs\RetailerRuleQualifier $retailerRuleQualifier
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setRetailerRuleQualifier(\Sabre\OTAAirPrice\Structs\RetailerRuleQualifier $retailerRuleQualifier = null)
    {
        $this->RetailerRuleQualifier = $retailerRuleQualifier;
        return $this;
    }
    /**
     * Get ShipsRegistry value
     * @return string|null
     */
    public function getShipsRegistry()
    {
        return $this->ShipsRegistry;
    }
    /**
     * Set ShipsRegistry value
     * @param string $shipsRegistry
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setShipsRegistry($shipsRegistry = null)
    {
        $this->ShipsRegistry = $shipsRegistry;
        return $this;
    }
    /**
     * Get SpanishLargeFamilyDiscountLevel value
     * @return string|null
     */
    public function getSpanishLargeFamilyDiscountLevel()
    {
        return $this->SpanishLargeFamilyDiscountLevel;
    }
    /**
     * Set SpanishLargeFamilyDiscountLevel value
     * @uses \Sabre\OTAAirPrice\Enums\SpanishLargeFamilyDiscountLevel::valueIsValid()
     * @uses \Sabre\OTAAirPrice\Enums\SpanishLargeFamilyDiscountLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $spanishLargeFamilyDiscountLevel
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setSpanishLargeFamilyDiscountLevel($spanishLargeFamilyDiscountLevel = null)
    {
        $this->SpanishLargeFamilyDiscountLevel = $spanishLargeFamilyDiscountLevel;
        return $this;
    }
    /**
     * Get SpecificFare value
     * @return \Sabre\OTAAirPrice\Structs\SpecificFare[]|null
     */
    public function getSpecificFare()
    {
        return $this->SpecificFare;
    }
    /**
     * Set SpecificFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SpecificFare[] $specificFare
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setSpecificFare(array $specificFare = array())
    {
        $this->SpecificFare = $specificFare;
        return $this;
    }
    /**
     * Add item to SpecificFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SpecificFare $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToSpecificFare(\Sabre\OTAAirPrice\Structs\SpecificFare $item)
    {
        $this->SpecificFare[] = $item;
        return $this;
    }
    /**
     * Get SpecificPenalty value
     * @return \Sabre\OTAAirPrice\Structs\SpecificPenalty|null
     */
    public function getSpecificPenalty()
    {
        return $this->SpecificPenalty;
    }
    /**
     * Set SpecificPenalty value
     * @param \Sabre\OTAAirPrice\Structs\SpecificPenalty $specificPenalty
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setSpecificPenalty(\Sabre\OTAAirPrice\Structs\SpecificPenalty $specificPenalty = null)
    {
        $this->SpecificPenalty = $specificPenalty;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\OTAAirPrice\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\OTAAirPrice\Structs\Taxes $taxes
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setTaxes(\Sabre\OTAAirPrice\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get ValidityDates value
     * @return \Sabre\OTAAirPrice\Structs\ValidityDates[]|null
     */
    public function getValidityDates()
    {
        return $this->ValidityDates;
    }
    /**
     * Set ValidityDates value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ValidityDates[] $validityDates
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setValidityDates(array $validityDates = array())
    {
        $this->ValidityDates = $validityDates;
        return $this;
    }
    /**
     * Add item to ValidityDates value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ValidityDates $item
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function addToValidityDates(\Sabre\OTAAirPrice\Structs\ValidityDates $item)
    {
        $this->ValidityDates[] = $item;
        return $this;
    }
    /**
     * Get AlternateCurrencyCode value
     * @return string|null
     */
    public function getAlternateCurrencyCode()
    {
        return $this->AlternateCurrencyCode;
    }
    /**
     * Set AlternateCurrencyCode value
     * @param string $alternateCurrencyCode
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setAlternateCurrencyCode($alternateCurrencyCode = null)
    {
        $this->AlternateCurrencyCode = $alternateCurrencyCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get AggregatedContentExclude value
     * @return bool|null
     */
    public function getAggregatedContentExclude()
    {
        return $this->AggregatedContentExclude;
    }
    /**
     * Set AggregatedContentExclude value
     * @param bool $aggregatedContentExclude
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setAggregatedContentExclude($aggregatedContentExclude = null)
    {
        $this->AggregatedContentExclude = $aggregatedContentExclude;
        return $this;
    }
    /**
     * Get FareFocusExclude value
     * @return bool|null
     */
    public function getFareFocusExclude()
    {
        return $this->FareFocusExclude;
    }
    /**
     * Set FareFocusExclude value
     * @param bool $fareFocusExclude
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setFareFocusExclude($fareFocusExclude = null)
    {
        $this->FareFocusExclude = $fareFocusExclude;
        return $this;
    }
    /**
     * Get NoDate value
     * @return bool|null
     */
    public function getNoDate()
    {
        return $this->NoDate;
    }
    /**
     * Set NoDate value
     * @param bool $noDate
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setNoDate($noDate = null)
    {
        $this->NoDate = $noDate;
        return $this;
    }
    /**
     * Get RoundTheWorld value
     * @return bool|null
     */
    public function getRoundTheWorld()
    {
        return $this->RoundTheWorld;
    }
    /**
     * Set RoundTheWorld value
     * @param bool $roundTheWorld
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setRoundTheWorld($roundTheWorld = null)
    {
        $this->RoundTheWorld = $roundTheWorld;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public function setSource($source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\PricingQualifiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
