<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCard Structs
 * @subpackage Structs
 */
class PaymentCard extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A type representing credit card expiration date. Accepted format: "yyyy-mm"
     * - pattern: \d{4}-\d{2}
     * @var int
     */
    public $ExpireDate;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The ExtendedPayment
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $ExtendedPayment;
    /**
     * The ManualApprovalCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ManualApprovalCode;
    /**
     * The CardSecurityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $CardSecurityCode;
    /**
     * Constructor method for PaymentCard
     * @uses PaymentCard::setCode()
     * @uses PaymentCard::setExpireDate()
     * @uses PaymentCard::setNumber()
     * @uses PaymentCard::setExtendedPayment()
     * @uses PaymentCard::setManualApprovalCode()
     * @uses PaymentCard::setCardSecurityCode()
     * @param string $code
     * @param int $expireDate
     * @param int $number
     * @param int $extendedPayment
     * @param string $manualApprovalCode
     * @param int $cardSecurityCode
     */
    public function __construct($code = null, $expireDate = null, $number = null, $extendedPayment = null, $manualApprovalCode = null, $cardSecurityCode = null)
    {
        $this
            ->setCode($code)
            ->setExpireDate($expireDate)
            ->setNumber($number)
            ->setExtendedPayment($extendedPayment)
            ->setManualApprovalCode($manualApprovalCode)
            ->setCardSecurityCode($cardSecurityCode);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\OTAAirPrice\Structs\PaymentCard
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return int
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param int $expireDate
     * @return \Sabre\OTAAirPrice\Structs\PaymentCard
     */
    public function setExpireDate($expireDate = null)
    {
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\OTAAirPrice\Structs\PaymentCard
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ExtendedPayment value
     * @return int|null
     */
    public function getExtendedPayment()
    {
        return $this->ExtendedPayment;
    }
    /**
     * Set ExtendedPayment value
     * @param int $extendedPayment
     * @return \Sabre\OTAAirPrice\Structs\PaymentCard
     */
    public function setExtendedPayment($extendedPayment = null)
    {
        $this->ExtendedPayment = $extendedPayment;
        return $this;
    }
    /**
     * Get ManualApprovalCode value
     * @return string|null
     */
    public function getManualApprovalCode()
    {
        return $this->ManualApprovalCode;
    }
    /**
     * Set ManualApprovalCode value
     * @param string $manualApprovalCode
     * @return \Sabre\OTAAirPrice\Structs\PaymentCard
     */
    public function setManualApprovalCode($manualApprovalCode = null)
    {
        $this->ManualApprovalCode = $manualApprovalCode;
        return $this;
    }
    /**
     * Get CardSecurityCode value
     * @return int|null
     */
    public function getCardSecurityCode()
    {
        return $this->CardSecurityCode;
    }
    /**
     * Set CardSecurityCode value
     * @param int $cardSecurityCode
     * @return \Sabre\OTAAirPrice\Structs\PaymentCard
     */
    public function setCardSecurityCode($cardSecurityCode = null)
    {
        $this->CardSecurityCode = $cardSecurityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\PaymentCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
