<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTC_FareBreakdown Structs
 * @subpackage Structs
 */
class PTC_FareBreakdown extends AbstractStructBase
{
    /**
     * The BrandedFareInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\BrandedFareInformation
     */
    public $BrandedFareInformation;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Cabin;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\FareBasis
     */
    public $FareBasis;
    /**
     * The FreeBaggageAllowance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FreeBaggageAllowance;
    /**
     * The Surcharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Surcharges[]
     */
    public $Surcharges;
    /**
     * Constructor method for PTC_FareBreakdown
     * @uses PTC_FareBreakdown::setBrandedFareInformation()
     * @uses PTC_FareBreakdown::setCabin()
     * @uses PTC_FareBreakdown::setFareBasis()
     * @uses PTC_FareBreakdown::setFreeBaggageAllowance()
     * @uses PTC_FareBreakdown::setSurcharges()
     * @param \Sabre\OTAAirPrice\Structs\BrandedFareInformation $brandedFareInformation
     * @param string $cabin
     * @param \Sabre\OTAAirPrice\Structs\FareBasis $fareBasis
     * @param string $freeBaggageAllowance
     * @param \Sabre\OTAAirPrice\Structs\Surcharges[] $surcharges
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\BrandedFareInformation $brandedFareInformation = null, $cabin = null, \Sabre\OTAAirPrice\Structs\FareBasis $fareBasis = null, $freeBaggageAllowance = null, array $surcharges = array())
    {
        $this
            ->setBrandedFareInformation($brandedFareInformation)
            ->setCabin($cabin)
            ->setFareBasis($fareBasis)
            ->setFreeBaggageAllowance($freeBaggageAllowance)
            ->setSurcharges($surcharges);
    }
    /**
     * Get BrandedFareInformation value
     * @return \Sabre\OTAAirPrice\Structs\BrandedFareInformation|null
     */
    public function getBrandedFareInformation()
    {
        return $this->BrandedFareInformation;
    }
    /**
     * Set BrandedFareInformation value
     * @param \Sabre\OTAAirPrice\Structs\BrandedFareInformation $brandedFareInformation
     * @return \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown
     */
    public function setBrandedFareInformation(\Sabre\OTAAirPrice\Structs\BrandedFareInformation $brandedFareInformation = null)
    {
        $this->BrandedFareInformation = $brandedFareInformation;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown
     */
    public function setCabin($cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\OTAAirPrice\Structs\FareBasis|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param \Sabre\OTAAirPrice\Structs\FareBasis $fareBasis
     * @return \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown
     */
    public function setFareBasis(\Sabre\OTAAirPrice\Structs\FareBasis $fareBasis = null)
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get FreeBaggageAllowance value
     * @return string|null
     */
    public function getFreeBaggageAllowance()
    {
        return $this->FreeBaggageAllowance;
    }
    /**
     * Set FreeBaggageAllowance value
     * @param string $freeBaggageAllowance
     * @return \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown
     */
    public function setFreeBaggageAllowance($freeBaggageAllowance = null)
    {
        $this->FreeBaggageAllowance = $freeBaggageAllowance;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \Sabre\OTAAirPrice\Structs\Surcharges[]|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Surcharges[] $surcharges
     * @return \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown
     */
    public function setSurcharges(array $surcharges = array())
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
    /**
     * Add item to Surcharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Surcharges $item
     * @return \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown
     */
    public function addToSurcharges(\Sabre\OTAAirPrice\Structs\Surcharges $item)
    {
        $this->Surcharges[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
