<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginLocation Structs
 * @subpackage Structs
 */
class OriginLocation extends AbstractStructBase
{
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $RPH;
    /**
     * Constructor method for OriginLocation
     * @uses OriginLocation::setLocationCode()
     * @uses OriginLocation::setRPH()
     * @param string $locationCode
     * @param int $rPH
     */
    public function __construct($locationCode = null, $rPH = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setRPH($rPH);
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\OTAAirPrice\Structs\OriginLocation
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \Sabre\OTAAirPrice\Structs\OriginLocation
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\OriginLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
