<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscInformation Structs
 * @subpackage Structs
 */
class MiscInformation extends AbstractStructBase
{
    /**
     * The BaggageInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\BaggageInfo
     */
    public $BaggageInfo;
    /**
     * The HeaderInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\HeaderInformation[]
     */
    public $HeaderInformation;
    /**
     * The SolutionInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\SolutionInformation[]
     */
    public $SolutionInformation;
    /**
     * The OptionalCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\OptionalCharges[]
     */
    public $OptionalCharges;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ValidatingCarrier[]
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for MiscInformation
     * @uses MiscInformation::setBaggageInfo()
     * @uses MiscInformation::setHeaderInformation()
     * @uses MiscInformation::setSolutionInformation()
     * @uses MiscInformation::setOptionalCharges()
     * @uses MiscInformation::setValidatingCarrier()
     * @param \Sabre\OTAAirPrice\Structs\BaggageInfo $baggageInfo
     * @param \Sabre\OTAAirPrice\Structs\HeaderInformation[] $headerInformation
     * @param \Sabre\OTAAirPrice\Structs\SolutionInformation[] $solutionInformation
     * @param \Sabre\OTAAirPrice\Structs\OptionalCharges[] $optionalCharges
     * @param \Sabre\OTAAirPrice\Structs\ValidatingCarrier[] $validatingCarrier
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\BaggageInfo $baggageInfo = null, array $headerInformation = array(), array $solutionInformation = array(), array $optionalCharges = array(), array $validatingCarrier = array())
    {
        $this
            ->setBaggageInfo($baggageInfo)
            ->setHeaderInformation($headerInformation)
            ->setSolutionInformation($solutionInformation)
            ->setOptionalCharges($optionalCharges)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get BaggageInfo value
     * @return \Sabre\OTAAirPrice\Structs\BaggageInfo|null
     */
    public function getBaggageInfo()
    {
        return $this->BaggageInfo;
    }
    /**
     * Set BaggageInfo value
     * @param \Sabre\OTAAirPrice\Structs\BaggageInfo $baggageInfo
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function setBaggageInfo(\Sabre\OTAAirPrice\Structs\BaggageInfo $baggageInfo = null)
    {
        $this->BaggageInfo = $baggageInfo;
        return $this;
    }
    /**
     * Get HeaderInformation value
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation[]|null
     */
    public function getHeaderInformation()
    {
        return $this->HeaderInformation;
    }
    /**
     * Set HeaderInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\HeaderInformation[] $headerInformation
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function setHeaderInformation(array $headerInformation = array())
    {
        $this->HeaderInformation = $headerInformation;
        return $this;
    }
    /**
     * Add item to HeaderInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\HeaderInformation $item
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function addToHeaderInformation(\Sabre\OTAAirPrice\Structs\HeaderInformation $item)
    {
        $this->HeaderInformation[] = $item;
        return $this;
    }
    /**
     * Get SolutionInformation value
     * @return \Sabre\OTAAirPrice\Structs\SolutionInformation[]|null
     */
    public function getSolutionInformation()
    {
        return $this->SolutionInformation;
    }
    /**
     * Set SolutionInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SolutionInformation[] $solutionInformation
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function setSolutionInformation(array $solutionInformation = array())
    {
        $this->SolutionInformation = $solutionInformation;
        return $this;
    }
    /**
     * Add item to SolutionInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SolutionInformation $item
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function addToSolutionInformation(\Sabre\OTAAirPrice\Structs\SolutionInformation $item)
    {
        $this->SolutionInformation[] = $item;
        return $this;
    }
    /**
     * Get OptionalCharges value
     * @return \Sabre\OTAAirPrice\Structs\OptionalCharges[]|null
     */
    public function getOptionalCharges()
    {
        return $this->OptionalCharges;
    }
    /**
     * Set OptionalCharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\OptionalCharges[] $optionalCharges
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function setOptionalCharges(array $optionalCharges = array())
    {
        $this->OptionalCharges = $optionalCharges;
        return $this;
    }
    /**
     * Add item to OptionalCharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\OptionalCharges $item
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function addToOptionalCharges(\Sabre\OTAAirPrice\Structs\OptionalCharges $item)
    {
        $this->OptionalCharges[] = $item;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier[]|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ValidatingCarrier[] $validatingCarrier
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function setValidatingCarrier(array $validatingCarrier = array())
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Add item to ValidatingCarrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\ValidatingCarrier $item
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public function addToValidatingCarrier(\Sabre\OTAAirPrice\Structs\ValidatingCarrier $item)
    {
        $this->ValidatingCarrier[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\MiscInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
