<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Markup Structs
 * @subpackage Structs
 */
class Markup extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * Constructor method for Markup
     * @uses Markup::setCode()
     * @uses Markup::setDescription()
     * @uses Markup::setAmount()
     * @param string $code
     * @param string $description
     * @param string $amount
     */
    public function __construct($code = null, $description = null, $amount = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setAmount($amount);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\OTAAirPrice\Structs\Markup
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\OTAAirPrice\Structs\Markup
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\OTAAirPrice\Structs\Markup
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\Markup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
