<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItinTotalFare Structs
 * @subpackage Structs
 */
class ItinTotalFare extends AbstractStructBase
{
    /**
     * The BaggageInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\BaggageInfo
     */
    public $BaggageInfo;
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\BaseFare
     */
    public $BaseFare;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Commission
     */
    public $Commission;
    /**
     * The DiscountTypeMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DiscountTypeMessage;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Endorsements
     */
    public $Endorsements;
    /**
     * The EquivFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\EquivFare
     */
    public $EquivFare;
    /**
     * The PrivateFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\PrivateFare
     */
    public $PrivateFare;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Taxes
     */
    public $Taxes;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\TotalFare
     */
    public $TotalFare;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Warnings
     */
    public $Warnings;
    /**
     * The SellingFareData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\SellingFareData[]
     */
    public $SellingFareData;
    /**
     * The NonRefundableInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NonRefundableInd;
    /**
     * Constructor method for ItinTotalFare
     * @uses ItinTotalFare::setBaggageInfo()
     * @uses ItinTotalFare::setBaseFare()
     * @uses ItinTotalFare::setCommission()
     * @uses ItinTotalFare::setDiscountTypeMessage()
     * @uses ItinTotalFare::setEndorsements()
     * @uses ItinTotalFare::setEquivFare()
     * @uses ItinTotalFare::setPrivateFare()
     * @uses ItinTotalFare::setTaxes()
     * @uses ItinTotalFare::setTotalFare()
     * @uses ItinTotalFare::setWarnings()
     * @uses ItinTotalFare::setSellingFareData()
     * @uses ItinTotalFare::setNonRefundableInd()
     * @param \Sabre\OTAAirPrice\Structs\BaggageInfo $baggageInfo
     * @param \Sabre\OTAAirPrice\Structs\BaseFare $baseFare
     * @param \Sabre\OTAAirPrice\Structs\Commission $commission
     * @param string $discountTypeMessage
     * @param \Sabre\OTAAirPrice\Structs\Endorsements $endorsements
     * @param \Sabre\OTAAirPrice\Structs\EquivFare $equivFare
     * @param \Sabre\OTAAirPrice\Structs\PrivateFare $privateFare
     * @param \Sabre\OTAAirPrice\Structs\Taxes $taxes
     * @param \Sabre\OTAAirPrice\Structs\TotalFare $totalFare
     * @param \Sabre\OTAAirPrice\Structs\Warnings $warnings
     * @param \Sabre\OTAAirPrice\Structs\SellingFareData[] $sellingFareData
     * @param string $nonRefundableInd
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\BaggageInfo $baggageInfo = null, \Sabre\OTAAirPrice\Structs\BaseFare $baseFare = null, \Sabre\OTAAirPrice\Structs\Commission $commission = null, $discountTypeMessage = null, \Sabre\OTAAirPrice\Structs\Endorsements $endorsements = null, \Sabre\OTAAirPrice\Structs\EquivFare $equivFare = null, \Sabre\OTAAirPrice\Structs\PrivateFare $privateFare = null, \Sabre\OTAAirPrice\Structs\Taxes $taxes = null, \Sabre\OTAAirPrice\Structs\TotalFare $totalFare = null, \Sabre\OTAAirPrice\Structs\Warnings $warnings = null, array $sellingFareData = array(), $nonRefundableInd = null)
    {
        $this
            ->setBaggageInfo($baggageInfo)
            ->setBaseFare($baseFare)
            ->setCommission($commission)
            ->setDiscountTypeMessage($discountTypeMessage)
            ->setEndorsements($endorsements)
            ->setEquivFare($equivFare)
            ->setPrivateFare($privateFare)
            ->setTaxes($taxes)
            ->setTotalFare($totalFare)
            ->setWarnings($warnings)
            ->setSellingFareData($sellingFareData)
            ->setNonRefundableInd($nonRefundableInd);
    }
    /**
     * Get BaggageInfo value
     * @return \Sabre\OTAAirPrice\Structs\BaggageInfo|null
     */
    public function getBaggageInfo()
    {
        return $this->BaggageInfo;
    }
    /**
     * Set BaggageInfo value
     * @param \Sabre\OTAAirPrice\Structs\BaggageInfo $baggageInfo
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setBaggageInfo(\Sabre\OTAAirPrice\Structs\BaggageInfo $baggageInfo = null)
    {
        $this->BaggageInfo = $baggageInfo;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return \Sabre\OTAAirPrice\Structs\BaseFare|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \Sabre\OTAAirPrice\Structs\BaseFare $baseFare
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setBaseFare(\Sabre\OTAAirPrice\Structs\BaseFare $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get Commission value
     * @return \Sabre\OTAAirPrice\Structs\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \Sabre\OTAAirPrice\Structs\Commission $commission
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setCommission(\Sabre\OTAAirPrice\Structs\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get DiscountTypeMessage value
     * @return string|null
     */
    public function getDiscountTypeMessage()
    {
        return $this->DiscountTypeMessage;
    }
    /**
     * Set DiscountTypeMessage value
     * @param string $discountTypeMessage
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setDiscountTypeMessage($discountTypeMessage = null)
    {
        $this->DiscountTypeMessage = $discountTypeMessage;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \Sabre\OTAAirPrice\Structs\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \Sabre\OTAAirPrice\Structs\Endorsements $endorsements
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setEndorsements(\Sabre\OTAAirPrice\Structs\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \Sabre\OTAAirPrice\Structs\EquivFare|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \Sabre\OTAAirPrice\Structs\EquivFare $equivFare
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setEquivFare(\Sabre\OTAAirPrice\Structs\EquivFare $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get PrivateFare value
     * @return \Sabre\OTAAirPrice\Structs\PrivateFare|null
     */
    public function getPrivateFare()
    {
        return $this->PrivateFare;
    }
    /**
     * Set PrivateFare value
     * @param \Sabre\OTAAirPrice\Structs\PrivateFare $privateFare
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setPrivateFare(\Sabre\OTAAirPrice\Structs\PrivateFare $privateFare = null)
    {
        $this->PrivateFare = $privateFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\OTAAirPrice\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\OTAAirPrice\Structs\Taxes $taxes
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setTaxes(\Sabre\OTAAirPrice\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \Sabre\OTAAirPrice\Structs\TotalFare|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \Sabre\OTAAirPrice\Structs\TotalFare $totalFare
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setTotalFare(\Sabre\OTAAirPrice\Structs\TotalFare $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \Sabre\OTAAirPrice\Structs\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \Sabre\OTAAirPrice\Structs\Warnings $warnings
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setWarnings(\Sabre\OTAAirPrice\Structs\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get SellingFareData value
     * @return \Sabre\OTAAirPrice\Structs\SellingFareData[]|null
     */
    public function getSellingFareData()
    {
        return $this->SellingFareData;
    }
    /**
     * Set SellingFareData value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SellingFareData[] $sellingFareData
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setSellingFareData(array $sellingFareData = array())
    {
        $this->SellingFareData = $sellingFareData;
        return $this;
    }
    /**
     * Add item to SellingFareData value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SellingFareData $item
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function addToSellingFareData(\Sabre\OTAAirPrice\Structs\SellingFareData $item)
    {
        $this->SellingFareData[] = $item;
        return $this;
    }
    /**
     * Get NonRefundableInd value
     * @return string|null
     */
    public function getNonRefundableInd()
    {
        return $this->NonRefundableInd;
    }
    /**
     * Set NonRefundableInd value
     * @param string $nonRefundableInd
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public function setNonRefundableInd($nonRefundableInd = null)
    {
        $this->NonRefundableInd = $nonRefundableInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
