<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HeaderInformation Structs
 * @subpackage Structs
 */
class HeaderInformation extends AbstractStructBase
{
    /**
     * The BargainFinder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\BargainFinder
     */
    public $BargainFinder;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A full date type. Accepted format: "yyyy-mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern: \d{4}-\d{2}-\d{2} |
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDate;
    /**
     * The DivideParty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 24
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\DivideParty[]
     */
    public $DivideParty;
    /**
     * The LastTicketingDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $LastTicketingDate;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ValidatingCarrier
     */
    public $ValidatingCarrier;
    /**
     * The SolutionSequenceNmbr
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SolutionSequenceNmbr;
    /**
     * Constructor method for HeaderInformation
     * @uses HeaderInformation::setBargainFinder()
     * @uses HeaderInformation::setDepartureDate()
     * @uses HeaderInformation::setDivideParty()
     * @uses HeaderInformation::setLastTicketingDate()
     * @uses HeaderInformation::setText()
     * @uses HeaderInformation::setValidatingCarrier()
     * @uses HeaderInformation::setSolutionSequenceNmbr()
     * @param \Sabre\OTAAirPrice\Structs\BargainFinder $bargainFinder
     * @param string $departureDate
     * @param \Sabre\OTAAirPrice\Structs\DivideParty[] $divideParty
     * @param string $lastTicketingDate
     * @param string[] $text
     * @param \Sabre\OTAAirPrice\Structs\ValidatingCarrier $validatingCarrier
     * @param string $solutionSequenceNmbr
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\BargainFinder $bargainFinder = null, $departureDate = null, array $divideParty = array(), $lastTicketingDate = null, array $text = array(), \Sabre\OTAAirPrice\Structs\ValidatingCarrier $validatingCarrier = null, $solutionSequenceNmbr = null)
    {
        $this
            ->setBargainFinder($bargainFinder)
            ->setDepartureDate($departureDate)
            ->setDivideParty($divideParty)
            ->setLastTicketingDate($lastTicketingDate)
            ->setText($text)
            ->setValidatingCarrier($validatingCarrier)
            ->setSolutionSequenceNmbr($solutionSequenceNmbr);
    }
    /**
     * Get BargainFinder value
     * @return \Sabre\OTAAirPrice\Structs\BargainFinder|null
     */
    public function getBargainFinder()
    {
        return $this->BargainFinder;
    }
    /**
     * Set BargainFinder value
     * @param \Sabre\OTAAirPrice\Structs\BargainFinder $bargainFinder
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function setBargainFinder(\Sabre\OTAAirPrice\Structs\BargainFinder $bargainFinder = null)
    {
        $this->BargainFinder = $bargainFinder;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DivideParty value
     * @return \Sabre\OTAAirPrice\Structs\DivideParty[]|null
     */
    public function getDivideParty()
    {
        return $this->DivideParty;
    }
    /**
     * Set DivideParty value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\DivideParty[] $divideParty
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function setDivideParty(array $divideParty = array())
    {
        $this->DivideParty = $divideParty;
        return $this;
    }
    /**
     * Add item to DivideParty value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\DivideParty $item
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function addToDivideParty(\Sabre\OTAAirPrice\Structs\DivideParty $item)
    {
        $this->DivideParty[] = $item;
        return $this;
    }
    /**
     * Get LastTicketingDate value
     * @return string|null
     */
    public function getLastTicketingDate()
    {
        return $this->LastTicketingDate;
    }
    /**
     * Set LastTicketingDate value
     * @param string $lastTicketingDate
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function setLastTicketingDate($lastTicketingDate = null)
    {
        $this->LastTicketingDate = $lastTicketingDate;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \Sabre\OTAAirPrice\Structs\ValidatingCarrier|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \Sabre\OTAAirPrice\Structs\ValidatingCarrier $validatingCarrier
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function setValidatingCarrier(\Sabre\OTAAirPrice\Structs\ValidatingCarrier $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Get SolutionSequenceNmbr value
     * @return string|null
     */
    public function getSolutionSequenceNmbr()
    {
        return $this->SolutionSequenceNmbr;
    }
    /**
     * Set SolutionSequenceNmbr value
     * @param string $solutionSequenceNmbr
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public function setSolutionSequenceNmbr($solutionSequenceNmbr = null)
    {
        $this->SolutionSequenceNmbr = $solutionSequenceNmbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\HeaderInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
