<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryPricingInfo Structs
 * @subpackage Structs
 */
class AirItineraryPricingInfo extends AbstractStructBase
{
    /**
     * The AgencyCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 23
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\AgencyCommission[]
     */
    public $AgencyCommission;
    /**
     * The AncillaryFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\AncillaryFees[]
     */
    public $AncillaryFees;
    /**
     * The BaggageProvisions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\BaggageProvisions[]
     */
    public $BaggageProvisions;
    /**
     * The FareCalculation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\FareCalculation
     */
    public $FareCalculation;
    /**
     * The FareCalculationBreakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown[]
     */
    public $FareCalculationBreakdown;
    /**
     * The ItinTotalFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ItinTotalFare
     */
    public $ItinTotalFare;
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\PassengerTypeQuantity
     */
    public $PassengerTypeQuantity;
    /**
     * The PTC_FareBreakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown[]
     */
    public $PTC_FareBreakdown;
    /**
     * The RetailerRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\RetailerRules[]
     */
    public $RetailerRules;
    /**
     * The SpecificPenalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\SpecificPenalty[]
     */
    public $SpecificPenalty;
    /**
     * The TicketingFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\TicketingFees[]
     */
    public $TicketingFees;
    /**
     * The SolutionSequenceNmbr
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SolutionSequenceNmbr;
    /**
     * Constructor method for AirItineraryPricingInfo
     * @uses AirItineraryPricingInfo::setAgencyCommission()
     * @uses AirItineraryPricingInfo::setAncillaryFees()
     * @uses AirItineraryPricingInfo::setBaggageProvisions()
     * @uses AirItineraryPricingInfo::setFareCalculation()
     * @uses AirItineraryPricingInfo::setFareCalculationBreakdown()
     * @uses AirItineraryPricingInfo::setItinTotalFare()
     * @uses AirItineraryPricingInfo::setPassengerTypeQuantity()
     * @uses AirItineraryPricingInfo::setPTC_FareBreakdown()
     * @uses AirItineraryPricingInfo::setRetailerRules()
     * @uses AirItineraryPricingInfo::setSpecificPenalty()
     * @uses AirItineraryPricingInfo::setTicketingFees()
     * @uses AirItineraryPricingInfo::setSolutionSequenceNmbr()
     * @param \Sabre\OTAAirPrice\Structs\AgencyCommission[] $agencyCommission
     * @param \Sabre\OTAAirPrice\Structs\AncillaryFees[] $ancillaryFees
     * @param \Sabre\OTAAirPrice\Structs\BaggageProvisions[] $baggageProvisions
     * @param \Sabre\OTAAirPrice\Structs\FareCalculation $fareCalculation
     * @param \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown[] $fareCalculationBreakdown
     * @param \Sabre\OTAAirPrice\Structs\ItinTotalFare $itinTotalFare
     * @param \Sabre\OTAAirPrice\Structs\PassengerTypeQuantity $passengerTypeQuantity
     * @param \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown[] $pTC_FareBreakdown
     * @param \Sabre\OTAAirPrice\Structs\RetailerRules[] $retailerRules
     * @param \Sabre\OTAAirPrice\Structs\SpecificPenalty[] $specificPenalty
     * @param \Sabre\OTAAirPrice\Structs\TicketingFees[] $ticketingFees
     * @param string $solutionSequenceNmbr
     */
    public function __construct(array $agencyCommission = array(), array $ancillaryFees = array(), array $baggageProvisions = array(), \Sabre\OTAAirPrice\Structs\FareCalculation $fareCalculation = null, array $fareCalculationBreakdown = array(), \Sabre\OTAAirPrice\Structs\ItinTotalFare $itinTotalFare = null, \Sabre\OTAAirPrice\Structs\PassengerTypeQuantity $passengerTypeQuantity = null, array $pTC_FareBreakdown = array(), array $retailerRules = array(), array $specificPenalty = array(), array $ticketingFees = array(), $solutionSequenceNmbr = null)
    {
        $this
            ->setAgencyCommission($agencyCommission)
            ->setAncillaryFees($ancillaryFees)
            ->setBaggageProvisions($baggageProvisions)
            ->setFareCalculation($fareCalculation)
            ->setFareCalculationBreakdown($fareCalculationBreakdown)
            ->setItinTotalFare($itinTotalFare)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setPTC_FareBreakdown($pTC_FareBreakdown)
            ->setRetailerRules($retailerRules)
            ->setSpecificPenalty($specificPenalty)
            ->setTicketingFees($ticketingFees)
            ->setSolutionSequenceNmbr($solutionSequenceNmbr);
    }
    /**
     * Get AgencyCommission value
     * @return \Sabre\OTAAirPrice\Structs\AgencyCommission[]|null
     */
    public function getAgencyCommission()
    {
        return $this->AgencyCommission;
    }
    /**
     * Set AgencyCommission value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\AgencyCommission[] $agencyCommission
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setAgencyCommission(array $agencyCommission = array())
    {
        $this->AgencyCommission = $agencyCommission;
        return $this;
    }
    /**
     * Add item to AgencyCommission value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\AgencyCommission $item
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function addToAgencyCommission(\Sabre\OTAAirPrice\Structs\AgencyCommission $item)
    {
        $this->AgencyCommission[] = $item;
        return $this;
    }
    /**
     * Get AncillaryFees value
     * @return \Sabre\OTAAirPrice\Structs\AncillaryFees[]|null
     */
    public function getAncillaryFees()
    {
        return $this->AncillaryFees;
    }
    /**
     * Set AncillaryFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\AncillaryFees[] $ancillaryFees
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setAncillaryFees(array $ancillaryFees = array())
    {
        $this->AncillaryFees = $ancillaryFees;
        return $this;
    }
    /**
     * Add item to AncillaryFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\AncillaryFees $item
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function addToAncillaryFees(\Sabre\OTAAirPrice\Structs\AncillaryFees $item)
    {
        $this->AncillaryFees[] = $item;
        return $this;
    }
    /**
     * Get BaggageProvisions value
     * @return \Sabre\OTAAirPrice\Structs\BaggageProvisions[]|null
     */
    public function getBaggageProvisions()
    {
        return $this->BaggageProvisions;
    }
    /**
     * Set BaggageProvisions value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\BaggageProvisions[] $baggageProvisions
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setBaggageProvisions(array $baggageProvisions = array())
    {
        $this->BaggageProvisions = $baggageProvisions;
        return $this;
    }
    /**
     * Add item to BaggageProvisions value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\BaggageProvisions $item
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function addToBaggageProvisions(\Sabre\OTAAirPrice\Structs\BaggageProvisions $item)
    {
        $this->BaggageProvisions[] = $item;
        return $this;
    }
    /**
     * Get FareCalculation value
     * @return \Sabre\OTAAirPrice\Structs\FareCalculation|null
     */
    public function getFareCalculation()
    {
        return $this->FareCalculation;
    }
    /**
     * Set FareCalculation value
     * @param \Sabre\OTAAirPrice\Structs\FareCalculation $fareCalculation
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setFareCalculation(\Sabre\OTAAirPrice\Structs\FareCalculation $fareCalculation = null)
    {
        $this->FareCalculation = $fareCalculation;
        return $this;
    }
    /**
     * Get FareCalculationBreakdown value
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown[]|null
     */
    public function getFareCalculationBreakdown()
    {
        return $this->FareCalculationBreakdown;
    }
    /**
     * Set FareCalculationBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown[] $fareCalculationBreakdown
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setFareCalculationBreakdown(array $fareCalculationBreakdown = array())
    {
        $this->FareCalculationBreakdown = $fareCalculationBreakdown;
        return $this;
    }
    /**
     * Add item to FareCalculationBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown $item
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function addToFareCalculationBreakdown(\Sabre\OTAAirPrice\Structs\FareCalculationBreakdown $item)
    {
        $this->FareCalculationBreakdown[] = $item;
        return $this;
    }
    /**
     * Get ItinTotalFare value
     * @return \Sabre\OTAAirPrice\Structs\ItinTotalFare|null
     */
    public function getItinTotalFare()
    {
        return $this->ItinTotalFare;
    }
    /**
     * Set ItinTotalFare value
     * @param \Sabre\OTAAirPrice\Structs\ItinTotalFare $itinTotalFare
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setItinTotalFare(\Sabre\OTAAirPrice\Structs\ItinTotalFare $itinTotalFare = null)
    {
        $this->ItinTotalFare = $itinTotalFare;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \Sabre\OTAAirPrice\Structs\PassengerTypeQuantity|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \Sabre\OTAAirPrice\Structs\PassengerTypeQuantity $passengerTypeQuantity
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setPassengerTypeQuantity(\Sabre\OTAAirPrice\Structs\PassengerTypeQuantity $passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get PTC_FareBreakdown value
     * @return \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown[]|null
     */
    public function getPTC_FareBreakdown()
    {
        return $this->PTC_FareBreakdown;
    }
    /**
     * Set PTC_FareBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown[] $pTC_FareBreakdown
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setPTC_FareBreakdown(array $pTC_FareBreakdown = array())
    {
        $this->PTC_FareBreakdown = $pTC_FareBreakdown;
        return $this;
    }
    /**
     * Add item to PTC_FareBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\PTC_FareBreakdown $item
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function addToPTC_FareBreakdown(\Sabre\OTAAirPrice\Structs\PTC_FareBreakdown $item)
    {
        $this->PTC_FareBreakdown[] = $item;
        return $this;
    }
    /**
     * Get RetailerRules value
     * @return \Sabre\OTAAirPrice\Structs\RetailerRules[]|null
     */
    public function getRetailerRules()
    {
        return $this->RetailerRules;
    }
    /**
     * Set RetailerRules value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\RetailerRules[] $retailerRules
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setRetailerRules(array $retailerRules = array())
    {
        $this->RetailerRules = $retailerRules;
        return $this;
    }
    /**
     * Add item to RetailerRules value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\RetailerRules $item
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function addToRetailerRules(\Sabre\OTAAirPrice\Structs\RetailerRules $item)
    {
        $this->RetailerRules[] = $item;
        return $this;
    }
    /**
     * Get SpecificPenalty value
     * @return \Sabre\OTAAirPrice\Structs\SpecificPenalty[]|null
     */
    public function getSpecificPenalty()
    {
        return $this->SpecificPenalty;
    }
    /**
     * Set SpecificPenalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SpecificPenalty[] $specificPenalty
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setSpecificPenalty(array $specificPenalty = array())
    {
        $this->SpecificPenalty = $specificPenalty;
        return $this;
    }
    /**
     * Add item to SpecificPenalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\SpecificPenalty $item
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function addToSpecificPenalty(\Sabre\OTAAirPrice\Structs\SpecificPenalty $item)
    {
        $this->SpecificPenalty[] = $item;
        return $this;
    }
    /**
     * Get TicketingFees value
     * @return \Sabre\OTAAirPrice\Structs\TicketingFees[]|null
     */
    public function getTicketingFees()
    {
        return $this->TicketingFees;
    }
    /**
     * Set TicketingFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\TicketingFees[] $ticketingFees
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setTicketingFees(array $ticketingFees = array())
    {
        $this->TicketingFees = $ticketingFees;
        return $this;
    }
    /**
     * Add item to TicketingFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\TicketingFees $item
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function addToTicketingFees(\Sabre\OTAAirPrice\Structs\TicketingFees $item)
    {
        $this->TicketingFees[] = $item;
        return $this;
    }
    /**
     * Get SolutionSequenceNmbr value
     * @return string|null
     */
    public function getSolutionSequenceNmbr()
    {
        return $this->SolutionSequenceNmbr;
    }
    /**
     * Set SolutionSequenceNmbr value
     * @param string $solutionSequenceNmbr
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public function setSolutionSequenceNmbr($solutionSequenceNmbr = null)
    {
        $this->SolutionSequenceNmbr = $solutionSequenceNmbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
