<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyCommission Structs
 * @subpackage Structs
 */
class AgencyCommission extends AbstractStructBase
{
    /**
     * The CommissionContract
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommissionContract;
    /**
     * The TotalPricedCommission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TotalPricedCommission;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for AgencyCommission
     * @uses AgencyCommission::setCommissionContract()
     * @uses AgencyCommission::setTotalPricedCommission()
     * @uses AgencyCommission::setValidatingCarrier()
     * @param string $commissionContract
     * @param string $totalPricedCommission
     * @param string $validatingCarrier
     */
    public function __construct($commissionContract = null, $totalPricedCommission = null, $validatingCarrier = null)
    {
        $this
            ->setCommissionContract($commissionContract)
            ->setTotalPricedCommission($totalPricedCommission)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get CommissionContract value
     * @return string|null
     */
    public function getCommissionContract()
    {
        return $this->CommissionContract;
    }
    /**
     * Set CommissionContract value
     * @param string $commissionContract
     * @return \Sabre\OTAAirPrice\Structs\AgencyCommission
     */
    public function setCommissionContract($commissionContract = null)
    {
        $this->CommissionContract = $commissionContract;
        return $this;
    }
    /**
     * Get TotalPricedCommission value
     * @return string|null
     */
    public function getTotalPricedCommission()
    {
        return $this->TotalPricedCommission;
    }
    /**
     * Set TotalPricedCommission value
     * @param string $totalPricedCommission
     * @return \Sabre\OTAAirPrice\Structs\AgencyCommission
     */
    public function setTotalPricedCommission($totalPricedCommission = null)
    {
        $this->TotalPricedCommission = $totalPricedCommission;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \Sabre\OTAAirPrice\Structs\AgencyCommission
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\AgencyCommission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
