<?php

namespace Sabre\ContextChange\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContextChangeRS Structs
 * @subpackage Structs
 */
class ContextChangeRS extends AbstractStructBase
{
    /**
     * The ApplicationResults
     * Meta informations extracted from the WSDL
     * - ref: stl:ApplicationResults
     * @var \Sabre\ContextChange\Structs\ApplicationResults
     */
    public $ApplicationResults;
    /**
     * The SecurityToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\ContextChange\Structs\SecurityToken
     */
    public $SecurityToken;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for ContextChangeRS
     * @uses ContextChangeRS::setApplicationResults()
     * @uses ContextChangeRS::setSecurityToken()
     * @uses ContextChangeRS::setText()
     * @uses ContextChangeRS::setVersion()
     * @param \Sabre\ContextChange\Structs\ApplicationResults $applicationResults
     * @param \Sabre\ContextChange\Structs\SecurityToken $securityToken
     * @param string[] $text
     * @param string $version
     */
    public function __construct(\Sabre\ContextChange\Structs\ApplicationResults $applicationResults = null, \Sabre\ContextChange\Structs\SecurityToken $securityToken = null, array $text = array(), $version = null)
    {
        $this
            ->setApplicationResults($applicationResults)
            ->setSecurityToken($securityToken)
            ->setText($text)
            ->setVersion($version);
    }
    /**
     * Get ApplicationResults value
     * @return \Sabre\ContextChange\Structs\ApplicationResults|null
     */
    public function getApplicationResults()
    {
        return $this->ApplicationResults;
    }
    /**
     * Set ApplicationResults value
     * @param \Sabre\ContextChange\Structs\ApplicationResults $applicationResults
     * @return \Sabre\ContextChange\Structs\ContextChangeRS
     */
    public function setApplicationResults(\Sabre\ContextChange\Structs\ApplicationResults $applicationResults = null)
    {
        $this->ApplicationResults = $applicationResults;
        return $this;
    }
    /**
     * Get SecurityToken value
     * @return \Sabre\ContextChange\Structs\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->SecurityToken;
    }
    /**
     * Set SecurityToken value
     * @param \Sabre\ContextChange\Structs\SecurityToken $securityToken
     * @return \Sabre\ContextChange\Structs\ContextChangeRS
     */
    public function setSecurityToken(\Sabre\ContextChange\Structs\SecurityToken $securityToken = null)
    {
        $this->SecurityToken = $securityToken;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\ContextChange\Structs\ContextChangeRS
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\ContextChange\Structs\ContextChangeRS
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\ContextChange\Structs\ContextChangeRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\ContextChange\Structs\ContextChangeRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
