<?php

namespace Sabre\ContextChange\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangePartition Structs
 * @subpackage Structs
 */
class ChangePartition extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The NewPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $NewPassword;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $Password;
    /**
     * The PIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $PIN;
    /**
     * Constructor method for ChangePartition
     * @uses ChangePartition::setCode()
     * @uses ChangePartition::setNewPassword()
     * @uses ChangePartition::setPassword()
     * @uses ChangePartition::setPIN()
     * @param string $code
     * @param string $newPassword
     * @param string $password
     * @param string $pIN
     */
    public function __construct($code = null, $newPassword = null, $password = null, $pIN = null)
    {
        $this
            ->setCode($code)
            ->setNewPassword($newPassword)
            ->setPassword($password)
            ->setPIN($pIN);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\ContextChange\Structs\ChangePartition
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get NewPassword value
     * @return string|null
     */
    public function getNewPassword()
    {
        return $this->NewPassword;
    }
    /**
     * Set NewPassword value
     * @param string $newPassword
     * @return \Sabre\ContextChange\Structs\ChangePartition
     */
    public function setNewPassword($newPassword = null)
    {
        $this->NewPassword = $newPassword;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \Sabre\ContextChange\Structs\ChangePartition
     */
    public function setPassword($password = null)
    {
        $this->Password = $password;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \Sabre\ContextChange\Structs\ChangePartition
     */
    public function setPIN($pIN = null)
    {
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\ContextChange\Structs\ChangePartition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
