<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/ContextChangeLLS2.0.3RQ.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/ContextChangeLLS2.0.3RQ.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sabre\ContextChange\ClassMap::get(),
);
/**
 * Samples for Context ServiceType
 */
$context = new \Sabre\ContextChange\Services\Context($options);
$context->setSoapHeaderMessageHeader(new \Sabre\ContextChange\Structs\MessageHeader());
$context->setSoapHeaderSecurity(new \Sabre\ContextChange\Structs\Security());
/**
 * Sample call for ContextChangeRQ operation/method
 */
if ($context->ContextChangeRQ(new \Sabre\ContextChange\Structs\ContextChangeRQ()) !== false) {
    print_r($context->getResult());
} else {
    print_r($context->getLastError());
}
