<?php

namespace Sabre\ContextChange\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SabreHeader Structs
 * Meta informations extracted from the WSDL
 * - type: SabreHeader
 * @subpackage Structs
 */
class SabreHeader extends AbstractStructBase
{
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - ref: Service
     * @var \Sabre\ContextChange\Structs\Service
     */
    public $Service;
    /**
     * The Identification
     * Meta informations extracted from the WSDL
     * - ref: Identification
     * @var \Sabre\ContextChange\Structs\Identification
     */
    public $Identification;
    /**
     * The ResultSummary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ResultSummary
     * @var \Sabre\ContextChange\Structs\ResultSummary
     */
    public $ResultSummary;
    /**
     * The Security
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Security
     * @var \Sabre\ContextChange\Structs\Security
     */
    public $Security;
    /**
     * The Traces
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Traces
     * @var \Sabre\ContextChange\Structs\Traces
     */
    public $Traces;
    /**
     * The Diagnostics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Diagnostics
     * @var \Sabre\ContextChange\Structs\Diagnostics
     */
    public $Diagnostics;
    /**
     * Constructor method for SabreHeader
     * @uses SabreHeader::setService()
     * @uses SabreHeader::setIdentification()
     * @uses SabreHeader::setResultSummary()
     * @uses SabreHeader::setSecurity()
     * @uses SabreHeader::setTraces()
     * @uses SabreHeader::setDiagnostics()
     * @param \Sabre\ContextChange\Structs\Service $service
     * @param \Sabre\ContextChange\Structs\Identification $identification
     * @param \Sabre\ContextChange\Structs\ResultSummary $resultSummary
     * @param \Sabre\ContextChange\Structs\Security $security
     * @param \Sabre\ContextChange\Structs\Traces $traces
     * @param \Sabre\ContextChange\Structs\Diagnostics $diagnostics
     */
    public function __construct(\Sabre\ContextChange\Structs\Service $service = null, \Sabre\ContextChange\Structs\Identification $identification = null, \Sabre\ContextChange\Structs\ResultSummary $resultSummary = null, \Sabre\ContextChange\Structs\Security $security = null, \Sabre\ContextChange\Structs\Traces $traces = null, \Sabre\ContextChange\Structs\Diagnostics $diagnostics = null)
    {
        $this
            ->setService($service)
            ->setIdentification($identification)
            ->setResultSummary($resultSummary)
            ->setSecurity($security)
            ->setTraces($traces)
            ->setDiagnostics($diagnostics);
    }
    /**
     * Get Service value
     * @return \Sabre\ContextChange\Structs\Service|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Sabre\ContextChange\Structs\Service $service
     * @return \Sabre\ContextChange\Structs\SabreHeader
     */
    public function setService(\Sabre\ContextChange\Structs\Service $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get Identification value
     * @return \Sabre\ContextChange\Structs\Identification|null
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \Sabre\ContextChange\Structs\Identification $identification
     * @return \Sabre\ContextChange\Structs\SabreHeader
     */
    public function setIdentification(\Sabre\ContextChange\Structs\Identification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get ResultSummary value
     * @return \Sabre\ContextChange\Structs\ResultSummary|null
     */
    public function getResultSummary()
    {
        return $this->ResultSummary;
    }
    /**
     * Set ResultSummary value
     * @param \Sabre\ContextChange\Structs\ResultSummary $resultSummary
     * @return \Sabre\ContextChange\Structs\SabreHeader
     */
    public function setResultSummary(\Sabre\ContextChange\Structs\ResultSummary $resultSummary = null)
    {
        $this->ResultSummary = $resultSummary;
        return $this;
    }
    /**
     * Get Security value
     * @return \Sabre\ContextChange\Structs\Security|null
     */
    public function getSecurity()
    {
        return $this->Security;
    }
    /**
     * Set Security value
     * @param \Sabre\ContextChange\Structs\Security $security
     * @return \Sabre\ContextChange\Structs\SabreHeader
     */
    public function setSecurity(\Sabre\ContextChange\Structs\Security $security = null)
    {
        $this->Security = $security;
        return $this;
    }
    /**
     * Get Traces value
     * @return \Sabre\ContextChange\Structs\Traces|null
     */
    public function getTraces()
    {
        return $this->Traces;
    }
    /**
     * Set Traces value
     * @param \Sabre\ContextChange\Structs\Traces $traces
     * @return \Sabre\ContextChange\Structs\SabreHeader
     */
    public function setTraces(\Sabre\ContextChange\Structs\Traces $traces = null)
    {
        $this->Traces = $traces;
        return $this;
    }
    /**
     * Get Diagnostics value
     * @return \Sabre\ContextChange\Structs\Diagnostics|null
     */
    public function getDiagnostics()
    {
        return $this->Diagnostics;
    }
    /**
     * Set Diagnostics value
     * @param \Sabre\ContextChange\Structs\Diagnostics $diagnostics
     * @return \Sabre\ContextChange\Structs\SabreHeader
     */
    public function setDiagnostics(\Sabre\ContextChange\Structs\Diagnostics $diagnostics = null)
    {
        $this->Diagnostics = $diagnostics;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\ContextChange\Structs\SabreHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
