<?php

namespace Sabre\ContextChange\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverSign Structs
 * @subpackage Structs
 */
class OverSign extends AbstractStructBase
{
    /**
     * The Area
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $Area;
    /**
     * The DutyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $DutyCode;
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 5
     * @var string
     */
    public $Organization;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $Password;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxLength: 6
     * @var string
     */
    public $Username;
    /**
     * Constructor method for OverSign
     * @uses OverSign::setArea()
     * @uses OverSign::setDutyCode()
     * @uses OverSign::setOrganization()
     * @uses OverSign::setPassword()
     * @uses OverSign::setUsername()
     * @param string $area
     * @param string $dutyCode
     * @param string $organization
     * @param string $password
     * @param string $username
     */
    public function __construct($area = null, $dutyCode = null, $organization = null, $password = null, $username = null)
    {
        $this
            ->setArea($area)
            ->setDutyCode($dutyCode)
            ->setOrganization($organization)
            ->setPassword($password)
            ->setUsername($username);
    }
    /**
     * Get Area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * Set Area value
     * @param string $area
     * @return \Sabre\ContextChange\Structs\OverSign
     */
    public function setArea($area = null)
    {
        $this->Area = $area;
        return $this;
    }
    /**
     * Get DutyCode value
     * @return string|null
     */
    public function getDutyCode()
    {
        return $this->DutyCode;
    }
    /**
     * Set DutyCode value
     * @param string $dutyCode
     * @return \Sabre\ContextChange\Structs\OverSign
     */
    public function setDutyCode($dutyCode = null)
    {
        $this->DutyCode = $dutyCode;
        return $this;
    }
    /**
     * Get Organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param string $organization
     * @return \Sabre\ContextChange\Structs\OverSign
     */
    public function setOrganization($organization = null)
    {
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \Sabre\ContextChange\Structs\OverSign
     */
    public function setPassword($password = null)
    {
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \Sabre\ContextChange\Structs\OverSign
     */
    public function setUsername($username = null)
    {
        $this->Username = $username;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\ContextChange\Structs\OverSign
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
