<?php

namespace Sabre\ContextChange\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeAAA Structs
 * @subpackage Structs
 */
class ChangeAAA extends AbstractStructBase
{
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The AccountingCity
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AccountingCity;
    /**
     * The AccountingCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AccountingCode;
    /**
     * The OfficeStationCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $OfficeStationCode;
    /**
     * Constructor method for ChangeAAA
     * @uses ChangeAAA::setPseudoCityCode()
     * @uses ChangeAAA::setAccountingCity()
     * @uses ChangeAAA::setAccountingCode()
     * @uses ChangeAAA::setOfficeStationCode()
     * @param string $pseudoCityCode
     * @param string $accountingCity
     * @param string $accountingCode
     * @param string $officeStationCode
     */
    public function __construct($pseudoCityCode = null, $accountingCity = null, $accountingCode = null, $officeStationCode = null)
    {
        $this
            ->setPseudoCityCode($pseudoCityCode)
            ->setAccountingCity($accountingCity)
            ->setAccountingCode($accountingCode)
            ->setOfficeStationCode($officeStationCode);
    }
    /**
     * Get PseudoCityCode value
     * @return string
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\ContextChange\Structs\ChangeAAA
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get AccountingCity value
     * @return string|null
     */
    public function getAccountingCity()
    {
        return $this->AccountingCity;
    }
    /**
     * Set AccountingCity value
     * @param string $accountingCity
     * @return \Sabre\ContextChange\Structs\ChangeAAA
     */
    public function setAccountingCity($accountingCity = null)
    {
        $this->AccountingCity = $accountingCity;
        return $this;
    }
    /**
     * Get AccountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->AccountingCode;
    }
    /**
     * Set AccountingCode value
     * @param string $accountingCode
     * @return \Sabre\ContextChange\Structs\ChangeAAA
     */
    public function setAccountingCode($accountingCode = null)
    {
        $this->AccountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get OfficeStationCode value
     * @return string|null
     */
    public function getOfficeStationCode()
    {
        return $this->OfficeStationCode;
    }
    /**
     * Set OfficeStationCode value
     * @param string $officeStationCode
     * @return \Sabre\ContextChange\Structs\ChangeAAA
     */
    public function setOfficeStationCode($officeStationCode = null)
    {
        $this->OfficeStationCode = $officeStationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\ContextChange\Structs\ChangeAAA
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
