<?php

namespace Sabre\QueuePlace\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueuePlaceRS Structs
 * @subpackage Structs
 */
class QueuePlaceRS extends AbstractStructBase
{
    /**
     * The ApplicationResults
     * Meta informations extracted from the WSDL
     * - ref: stl:ApplicationResults
     * @var \Sabre\QueuePlace\Structs\ApplicationResults
     */
    public $ApplicationResults;
    /**
     * The QueueInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \Sabre\QueuePlace\Structs\QueueInfo[]
     */
    public $QueueInfo;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for QueuePlaceRS
     * @uses QueuePlaceRS::setApplicationResults()
     * @uses QueuePlaceRS::setQueueInfo()
     * @uses QueuePlaceRS::setText()
     * @uses QueuePlaceRS::setVersion()
     * @param \Sabre\QueuePlace\Structs\ApplicationResults $applicationResults
     * @param \Sabre\QueuePlace\Structs\QueueInfo[] $queueInfo
     * @param string[] $text
     * @param string $version
     */
    public function __construct(\Sabre\QueuePlace\Structs\ApplicationResults $applicationResults = null, array $queueInfo = array(), array $text = array(), $version = null)
    {
        $this
            ->setApplicationResults($applicationResults)
            ->setQueueInfo($queueInfo)
            ->setText($text)
            ->setVersion($version);
    }
    /**
     * Get ApplicationResults value
     * @return \Sabre\QueuePlace\Structs\ApplicationResults|null
     */
    public function getApplicationResults()
    {
        return $this->ApplicationResults;
    }
    /**
     * Set ApplicationResults value
     * @param \Sabre\QueuePlace\Structs\ApplicationResults $applicationResults
     * @return \Sabre\QueuePlace\Structs\QueuePlaceRS
     */
    public function setApplicationResults(\Sabre\QueuePlace\Structs\ApplicationResults $applicationResults = null)
    {
        $this->ApplicationResults = $applicationResults;
        return $this;
    }
    /**
     * Get QueueInfo value
     * @return \Sabre\QueuePlace\Structs\QueueInfo[]|null
     */
    public function getQueueInfo()
    {
        return $this->QueueInfo;
    }
    /**
     * Set QueueInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueuePlace\Structs\QueueInfo[] $queueInfo
     * @return \Sabre\QueuePlace\Structs\QueuePlaceRS
     */
    public function setQueueInfo(array $queueInfo = array())
    {
        $this->QueueInfo = $queueInfo;
        return $this;
    }
    /**
     * Add item to QueueInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueuePlace\Structs\QueueInfo $item
     * @return \Sabre\QueuePlace\Structs\QueuePlaceRS
     */
    public function addToQueueInfo(\Sabre\QueuePlace\Structs\QueueInfo $item)
    {
        $this->QueueInfo[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\QueuePlace\Structs\QueuePlaceRS
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\QueuePlace\Structs\QueuePlaceRS
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\QueuePlace\Structs\QueuePlaceRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueuePlace\Structs\QueuePlaceRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
