<?php

namespace Sabre\QueuePlace\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInfo Structs
 * @subpackage Structs
 */
class QueueInfo extends AbstractStructBase
{
    /**
     * The QueueIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Sabre\QueuePlace\Structs\QueueIdentifier
     */
    public $QueueIdentifier;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 6
     * - minOccurs: 0
     * @var \Sabre\QueuePlace\Structs\UniqueID
     */
    public $UniqueID;
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $DateTime;
    /**
     * Constructor method for QueueInfo
     * @uses QueueInfo::setQueueIdentifier()
     * @uses QueueInfo::setUniqueID()
     * @uses QueueInfo::setDateTime()
     * @param \Sabre\QueuePlace\Structs\QueueIdentifier $queueIdentifier
     * @param \Sabre\QueuePlace\Structs\UniqueID $uniqueID
     * @param string $dateTime
     */
    public function __construct(\Sabre\QueuePlace\Structs\QueueIdentifier $queueIdentifier = null, \Sabre\QueuePlace\Structs\UniqueID $uniqueID = null, $dateTime = null)
    {
        $this
            ->setQueueIdentifier($queueIdentifier)
            ->setUniqueID($uniqueID)
            ->setDateTime($dateTime);
    }
    /**
     * Get QueueIdentifier value
     * @return \Sabre\QueuePlace\Structs\QueueIdentifier|null
     */
    public function getQueueIdentifier()
    {
        return $this->QueueIdentifier;
    }
    /**
     * Set QueueIdentifier value
     * @param \Sabre\QueuePlace\Structs\QueueIdentifier $queueIdentifier
     * @return \Sabre\QueuePlace\Structs\QueueInfo
     */
    public function setQueueIdentifier(\Sabre\QueuePlace\Structs\QueueIdentifier $queueIdentifier = null)
    {
        $this->QueueIdentifier = $queueIdentifier;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \Sabre\QueuePlace\Structs\UniqueID|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \Sabre\QueuePlace\Structs\UniqueID $uniqueID
     * @return \Sabre\QueuePlace\Structs\QueueInfo
     */
    public function setUniqueID(\Sabre\QueuePlace\Structs\UniqueID $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \Sabre\QueuePlace\Structs\QueueInfo
     */
    public function setDateTime($dateTime = null)
    {
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueuePlace\Structs\QueueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
