<?php

namespace Sabre\QueuePlace\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueIdentifier Structs
 * @subpackage Structs
 */
class QueueIdentifier extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The PrefatoryInstructionCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PrefatoryInstructionCode;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * Constructor method for QueueIdentifier
     * @uses QueueIdentifier::setNumber()
     * @uses QueueIdentifier::setPrefatoryInstructionCode()
     * @uses QueueIdentifier::setPseudoCityCode()
     * @uses QueueIdentifier::setName()
     * @param string $number
     * @param string $prefatoryInstructionCode
     * @param string $pseudoCityCode
     * @param string $name
     */
    public function __construct($number = null, $prefatoryInstructionCode = null, $pseudoCityCode = null, $name = null)
    {
        $this
            ->setNumber($number)
            ->setPrefatoryInstructionCode($prefatoryInstructionCode)
            ->setPseudoCityCode($pseudoCityCode)
            ->setName($name);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\QueuePlace\Structs\QueueIdentifier
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get PrefatoryInstructionCode value
     * @return string|null
     */
    public function getPrefatoryInstructionCode()
    {
        return $this->PrefatoryInstructionCode;
    }
    /**
     * Set PrefatoryInstructionCode value
     * @param string $prefatoryInstructionCode
     * @return \Sabre\QueuePlace\Structs\QueueIdentifier
     */
    public function setPrefatoryInstructionCode($prefatoryInstructionCode = null)
    {
        $this->PrefatoryInstructionCode = $prefatoryInstructionCode;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\QueuePlace\Structs\QueueIdentifier
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\QueuePlace\Structs\QueueIdentifier
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueuePlace\Structs\QueueIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
