<?php

namespace Sabre\QueuePlace\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TraceRecord Structs
 * Meta informations extracted from the WSDL
 * - documentation: Record for all systems (consumer, proxies and gateways, providers) to use to trace the message. The value is the common system name.
 * - maxLength: 255
 * - minLength: 1
 * @subpackage Structs
 */
class TraceRecord extends AbstractStructBase
{
    /**
     * The start
     * Meta informations extracted from the WSDL
     * - documentation: When the system stated processing the message. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm",
     * "yyyy-mm-ddThh:mm"
     * - use: required
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $start;
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - documentation: The key attribute is similar to ConversationID but is provided by the service requestor or entrypoint gateway and must be unique across all Sabre gateways. Each gateway instance must prepend the ID value with its unique system
     * identifier. Internal service consumers must provide this value which may be their unique system identifier concantanated with the ConversationID. | Same as STL Text.Long - A field text characters and no other constraints.
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $key;
    /**
     * The end
     * Meta informations extracted from the WSDL
     * - documentation: When the system completed processing the message. Example: 2002-10-10T12:00:00+05:00. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats:
     * "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $end;
    /**
     * The appInstance
     * Meta informations extracted from the WSDL
     * - documentation: The application instance involved in the particular transaction. For example: PROD1
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $appInstance;
    /**
     * The cluster
     * Meta informations extracted from the WSDL
     * - documentation: The application server cluster involved in the particular transaction. Example: PROD TPFC SCC
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $cluster;
    /**
     * The host
     * Meta informations extracted from the WSDL
     * - documentation: The server name involved in the particular transaction. Example: PSS
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $host;
    /**
     * The targetURI
     * Meta informations extracted from the WSDL
     * - documentation: The targetURI is the endpoint address this system sent the message to. For ServiceProviders it should be the abstract service address which is the address used by registries to look up the actual service endpoint URI. The endpoint
     * address may be a queue name (MOM service name).
     * @var string
     */
    public $targetURI;
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * Constructor method for TraceRecord
     * @uses TraceRecord::setStart()
     * @uses TraceRecord::set_()
     * @uses TraceRecord::setKey()
     * @uses TraceRecord::setEnd()
     * @uses TraceRecord::setAppInstance()
     * @uses TraceRecord::setCluster()
     * @uses TraceRecord::setHost()
     * @uses TraceRecord::setTargetURI()
     * @uses TraceRecord::setRole()
     * @param string $start
     * @param string $_
     * @param string $key
     * @param string $end
     * @param string $appInstance
     * @param string $cluster
     * @param string $host
     * @param string $targetURI
     * @param string $role
     */
    public function __construct($start = null, $_ = null, $key = null, $end = null, $appInstance = null, $cluster = null, $host = null, $targetURI = null, $role = null)
    {
        $this
            ->setStart($start)
            ->set_($_)
            ->setKey($key)
            ->setEnd($end)
            ->setAppInstance($appInstance)
            ->setCluster($cluster)
            ->setHost($host)
            ->setTargetURI($targetURI)
            ->setRole($role);
    }
    /**
     * Get start value
     * @return string
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param string $start
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function setStart($start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function setKey($key = null)
    {
        $this->key = $key;
        return $this;
    }
    /**
     * Get end value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param string $end
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function setEnd($end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get appInstance value
     * @return string|null
     */
    public function getAppInstance()
    {
        return $this->appInstance;
    }
    /**
     * Set appInstance value
     * @param string $appInstance
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function setAppInstance($appInstance = null)
    {
        $this->appInstance = $appInstance;
        return $this;
    }
    /**
     * Get cluster value
     * @return string|null
     */
    public function getCluster()
    {
        return $this->cluster;
    }
    /**
     * Set cluster value
     * @param string $cluster
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function setCluster($cluster = null)
    {
        $this->cluster = $cluster;
        return $this;
    }
    /**
     * Get host value
     * @return string|null
     */
    public function getHost()
    {
        return $this->host;
    }
    /**
     * Set host value
     * @param string $host
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function setHost($host = null)
    {
        $this->host = $host;
        return $this;
    }
    /**
     * Get targetURI value
     * @return string|null
     */
    public function getTargetURI()
    {
        return $this->targetURI;
    }
    /**
     * Set targetURI value
     * @param string $targetURI
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function setTargetURI($targetURI = null)
    {
        $this->targetURI = $targetURI;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @uses \Sabre\QueuePlace\Enums\TraceRole::valueIsValid()
     * @uses \Sabre\QueuePlace\Enums\TraceRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $role
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public function setRole($role = null)
    {
        $this->role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueuePlace\Structs\TraceRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
