<?php

namespace Sabre\QueuePlace\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProblemSummary Structs
 * @subpackage Structs
 */
class ProblemSummary extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: An indication of the source of error when processing the request.
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: Impact of the error on process completion.
     * - use: required
     * @var string
     */
    public $status;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - documentation: The system that the reporting system deemed to be the cause of the problem. If omitted, the reporting system is also the source of the problem. For application errors, the element may identify a system the application is dependent
     * upon that failed to respond. For validation errors this may identify the service consumer.
     * - minOccurs: 0
     * @var \Sabre\QueuePlace\Structs\Identifier_System
     */
    public $Source;
    /**
     * The ReportingSystem
     * Meta informations extracted from the WSDL
     * - documentation: The system that created the results record. If the Source system identifier is omitted, the system identified here both was the cause of the problem and created the result record.
     * @var \Sabre\QueuePlace\Structs\Identifier_System
     */
    public $ReportingSystem;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: An informative code and message that describes the results. Note: the message code and text must NOT be required to process to understand retry/compensate status. This value should be the same as in the SystemSpecificResults in the
     * body.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\QueuePlace\Structs\Message_Condition
     */
    public $Message;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - documentation: An abbreviated version of the error in textual format. This value should be the same as in the SystemSpecificResults in the body. | Same as STL Text.Short - A field of text characters and no other constraints.
     * - minOccurs: 0
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $ShortText;
    /**
     * The timeStamp
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $timeStamp;
    /**
     * Constructor method for ProblemSummary
     * @uses ProblemSummary::setType()
     * @uses ProblemSummary::setStatus()
     * @uses ProblemSummary::setSource()
     * @uses ProblemSummary::setReportingSystem()
     * @uses ProblemSummary::setMessage()
     * @uses ProblemSummary::setShortText()
     * @uses ProblemSummary::setTimeStamp()
     * @param string $type
     * @param string $status
     * @param \Sabre\QueuePlace\Structs\Identifier_System $source
     * @param \Sabre\QueuePlace\Structs\Identifier_System $reportingSystem
     * @param \Sabre\QueuePlace\Structs\Message_Condition $message
     * @param string $shortText
     * @param string $timeStamp
     */
    public function __construct($type = null, $status = null, \Sabre\QueuePlace\Structs\Identifier_System $source = null, \Sabre\QueuePlace\Structs\Identifier_System $reportingSystem = null, \Sabre\QueuePlace\Structs\Message_Condition $message = null, $shortText = null, $timeStamp = null)
    {
        $this
            ->setType($type)
            ->setStatus($status)
            ->setSource($source)
            ->setReportingSystem($reportingSystem)
            ->setMessage($message)
            ->setShortText($shortText)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \Sabre\QueuePlace\Enums\ErrorType::valueIsValid()
     * @uses \Sabre\QueuePlace\Enums\ErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\QueuePlace\Structs\ProblemSummary
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Sabre\QueuePlace\Enums\CompletionCodes::valueIsValid()
     * @uses \Sabre\QueuePlace\Enums\CompletionCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Sabre\QueuePlace\Structs\ProblemSummary
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get Source value
     * @return \Sabre\QueuePlace\Structs\Identifier_System|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \Sabre\QueuePlace\Structs\Identifier_System $source
     * @return \Sabre\QueuePlace\Structs\ProblemSummary
     */
    public function setSource(\Sabre\QueuePlace\Structs\Identifier_System $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get ReportingSystem value
     * @return \Sabre\QueuePlace\Structs\Identifier_System|null
     */
    public function getReportingSystem()
    {
        return $this->ReportingSystem;
    }
    /**
     * Set ReportingSystem value
     * @param \Sabre\QueuePlace\Structs\Identifier_System $reportingSystem
     * @return \Sabre\QueuePlace\Structs\ProblemSummary
     */
    public function setReportingSystem(\Sabre\QueuePlace\Structs\Identifier_System $reportingSystem = null)
    {
        $this->ReportingSystem = $reportingSystem;
        return $this;
    }
    /**
     * Get Message value
     * @return \Sabre\QueuePlace\Structs\Message_Condition|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \Sabre\QueuePlace\Structs\Message_Condition $message
     * @return \Sabre\QueuePlace\Structs\ProblemSummary
     */
    public function setMessage(\Sabre\QueuePlace\Structs\Message_Condition $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\QueuePlace\Structs\ProblemSummary
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \Sabre\QueuePlace\Structs\ProblemSummary
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueuePlace\Structs\ProblemSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
