<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Traces Structs
 * Meta informations extracted from the WSDL
 * - type: Traces
 * @subpackage Structs
 */
class Traces extends AbstractStructBase
{
    /**
     * The Trace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\TraceRecord[]
     */
    public $Trace;
    /**
     * Constructor method for Traces
     * @uses Traces::setTrace()
     * @param \Sabre\QueueCount\Structs\TraceRecord[] $trace
     */
    public function __construct(array $trace = array())
    {
        $this
            ->setTrace($trace);
    }
    /**
     * Get Trace value
     * @return \Sabre\QueueCount\Structs\TraceRecord[]|null
     */
    public function getTrace()
    {
        return $this->Trace;
    }
    /**
     * Set Trace value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\TraceRecord[] $trace
     * @return \Sabre\QueueCount\Structs\Traces
     */
    public function setTrace(array $trace = array())
    {
        foreach ($trace as $tracesTraceItem) {
            // validation for constraint: itemType
            if (!$tracesTraceItem instanceof \Sabre\QueueCount\Structs\TraceRecord) {
                throw new \InvalidArgumentException(sprintf('The Trace property can only contain items of \Sabre\QueueCount\Structs\TraceRecord, "%s" given', is_object($tracesTraceItem) ? get_class($tracesTraceItem) : gettype($tracesTraceItem)), __LINE__);
            }
        }
        $this->Trace = $trace;
        return $this;
    }
    /**
     * Add item to Trace value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\TraceRecord $item
     * @return \Sabre\QueueCount\Structs\Traces
     */
    public function addToTrace(\Sabre\QueueCount\Structs\TraceRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\TraceRecord) {
            throw new \InvalidArgumentException(sprintf('The Trace property can only contain items of \Sabre\QueueCount\Structs\TraceRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Trace[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\Traces
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
