<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HostCommand Structs
 * Meta informations extracted from the WSDL
 * - documentation: Same as STL Text.Long - A field text characters and no other constraints.
 * - maxLength: 4096
 * - minLength: 0
 * @subpackage Structs
 */
class HostCommand extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Long - A field text characters and no other constraints.
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The LNIATA
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LNIATA;
    /**
     * Constructor method for HostCommand
     * @uses HostCommand::set_()
     * @uses HostCommand::setLNIATA()
     * @param string $_
     * @param string $lNIATA
     */
    public function __construct($_ = null, $lNIATA = null)
    {
        $this
            ->set_($_)
            ->setLNIATA($lNIATA);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\QueueCount\Structs\HostCommand
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 4096) || (is_array($_) && count($_) > 4096)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4096 element(s) or a scalar of 4096 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($_) && strlen($_) < 0) || (is_array($_) && count($_) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get LNIATA value
     * @return string|null
     */
    public function getLNIATA()
    {
        return $this->LNIATA;
    }
    /**
     * Set LNIATA value
     * @param string $lNIATA
     * @return \Sabre\QueueCount\Structs\HostCommand
     */
    public function setLNIATA($lNIATA = null)
    {
        // validation for constraint: string
        if (!is_null($lNIATA) && !is_string($lNIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lNIATA)), __LINE__);
        }
        $this->LNIATA = $lNIATA;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\HostCommand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
