<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TraceRecord Structs
 * Meta informations extracted from the WSDL
 * - documentation: Record for all systems (consumer, proxies and gateways, providers) to use to trace the message. The value is the common system name.
 * - maxLength: 255
 * - minLength: 1
 * @subpackage Structs
 */
class TraceRecord extends AbstractStructBase
{
    /**
     * The start
     * Meta informations extracted from the WSDL
     * - documentation: When the system stated processing the message. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm",
     * "yyyy-mm-ddThh:mm"
     * - use: required
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $start;
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - documentation: The key attribute is similar to ConversationID but is provided by the service requestor or entrypoint gateway and must be unique across all Sabre gateways. Each gateway instance must prepend the ID value with its unique system
     * identifier. Internal service consumers must provide this value which may be their unique system identifier concantanated with the ConversationID. | Same as STL Text.Long - A field text characters and no other constraints.
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $key;
    /**
     * The end
     * Meta informations extracted from the WSDL
     * - documentation: When the system completed processing the message. Example: 2002-10-10T12:00:00+05:00. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats:
     * "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $end;
    /**
     * The appInstance
     * Meta informations extracted from the WSDL
     * - documentation: The application instance involved in the particular transaction. For example: PROD1
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $appInstance;
    /**
     * The cluster
     * Meta informations extracted from the WSDL
     * - documentation: The application server cluster involved in the particular transaction. Example: PROD TPFC SCC
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $cluster;
    /**
     * The host
     * Meta informations extracted from the WSDL
     * - documentation: The server name involved in the particular transaction. Example: PSS
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $host;
    /**
     * The targetURI
     * Meta informations extracted from the WSDL
     * - documentation: The targetURI is the endpoint address this system sent the message to. For ServiceProviders it should be the abstract service address which is the address used by registries to look up the actual service endpoint URI. The endpoint
     * address may be a queue name (MOM service name).
     * @var string
     */
    public $targetURI;
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * Constructor method for TraceRecord
     * @uses TraceRecord::setStart()
     * @uses TraceRecord::set_()
     * @uses TraceRecord::setKey()
     * @uses TraceRecord::setEnd()
     * @uses TraceRecord::setAppInstance()
     * @uses TraceRecord::setCluster()
     * @uses TraceRecord::setHost()
     * @uses TraceRecord::setTargetURI()
     * @uses TraceRecord::setRole()
     * @param string $start
     * @param string $_
     * @param string $key
     * @param string $end
     * @param string $appInstance
     * @param string $cluster
     * @param string $host
     * @param string $targetURI
     * @param string $role
     */
    public function __construct($start = null, $_ = null, $key = null, $end = null, $appInstance = null, $cluster = null, $host = null, $targetURI = null, $role = null)
    {
        $this
            ->setStart($start)
            ->set_($_)
            ->setKey($key)
            ->setEnd($end)
            ->setAppInstance($appInstance)
            ->setCluster($cluster)
            ->setHost($host)
            ->setTargetURI($targetURI)
            ->setRole($role);
    }
    /**
     * Get start value
     * @return string
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param string $start
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function setStart($start = null)
    {
        // validation for constraint: pattern
        if (is_scalar($start) && !preg_match('/(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}/', $start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}", "%s" given', var_export($start, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 255) || (is_array($_) && count($_) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($_) && strlen($_) < 1) || (is_array($_) && count($_) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function setKey($key = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($key) && strlen($key) > 4096) || (is_array($key) && count($key) > 4096)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4096 element(s) or a scalar of 4096 character(s) at most, "%d" length given', is_scalar($key) ? strlen($key) : count($key)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($key) && strlen($key) < 0) || (is_array($key) && count($key) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get end value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param string $end
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function setEnd($end = null)
    {
        // validation for constraint: pattern
        if (is_scalar($end) && !preg_match('/(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}/', $end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}", "%s" given', var_export($end, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->end = $end;
        return $this;
    }
    /**
     * Get appInstance value
     * @return string|null
     */
    public function getAppInstance()
    {
        return $this->appInstance;
    }
    /**
     * Set appInstance value
     * @param string $appInstance
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function setAppInstance($appInstance = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($appInstance) && strlen($appInstance) > 255) || (is_array($appInstance) && count($appInstance) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($appInstance) ? strlen($appInstance) : count($appInstance)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($appInstance) && strlen($appInstance) < 1) || (is_array($appInstance) && count($appInstance) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($appInstance) && !is_string($appInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appInstance)), __LINE__);
        }
        $this->appInstance = $appInstance;
        return $this;
    }
    /**
     * Get cluster value
     * @return string|null
     */
    public function getCluster()
    {
        return $this->cluster;
    }
    /**
     * Set cluster value
     * @param string $cluster
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function setCluster($cluster = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cluster) && strlen($cluster) > 255) || (is_array($cluster) && count($cluster) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($cluster) ? strlen($cluster) : count($cluster)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cluster) && strlen($cluster) < 1) || (is_array($cluster) && count($cluster) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cluster) && !is_string($cluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cluster)), __LINE__);
        }
        $this->cluster = $cluster;
        return $this;
    }
    /**
     * Get host value
     * @return string|null
     */
    public function getHost()
    {
        return $this->host;
    }
    /**
     * Set host value
     * @param string $host
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function setHost($host = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($host) && strlen($host) > 255) || (is_array($host) && count($host) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($host) ? strlen($host) : count($host)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($host) && strlen($host) < 1) || (is_array($host) && count($host) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($host) && !is_string($host)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($host)), __LINE__);
        }
        $this->host = $host;
        return $this;
    }
    /**
     * Get targetURI value
     * @return string|null
     */
    public function getTargetURI()
    {
        return $this->targetURI;
    }
    /**
     * Set targetURI value
     * @param string $targetURI
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function setTargetURI($targetURI = null)
    {
        // validation for constraint: string
        if (!is_null($targetURI) && !is_string($targetURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetURI)), __LINE__);
        }
        $this->targetURI = $targetURI;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @uses \Sabre\QueueCount\Enums\TraceRole::valueIsValid()
     * @uses \Sabre\QueueCount\Enums\TraceRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $role
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public function setRole($role = null)
    {
        // validation for constraint: enumeration
        if (!\Sabre\QueueCount\Enums\TraceRole::valueIsValid($role)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $role, implode(', ', \Sabre\QueueCount\Enums\TraceRole::getValidValues())), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\TraceRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
