<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignedInfoType Structs
 * @subpackage Structs
 */
class SignedInfoType extends AbstractStructBase
{
    /**
     * The CanonicalizationMethod
     * Meta informations extracted from the WSDL
     * - ref: ds:CanonicalizationMethod
     * @var \Sabre\QueueCount\Structs\CanonicalizationMethodType
     */
    public $CanonicalizationMethod;
    /**
     * The SignatureMethod
     * Meta informations extracted from the WSDL
     * - ref: ds:SignatureMethod
     * @var \Sabre\QueueCount\Structs\SignatureMethodType
     */
    public $SignatureMethod;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:Reference
     * @var \Sabre\QueueCount\Structs\ReferenceType[]
     */
    public $Reference;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignedInfoType
     * @uses SignedInfoType::setCanonicalizationMethod()
     * @uses SignedInfoType::setSignatureMethod()
     * @uses SignedInfoType::setReference()
     * @uses SignedInfoType::setId()
     * @param \Sabre\QueueCount\Structs\CanonicalizationMethodType $canonicalizationMethod
     * @param \Sabre\QueueCount\Structs\SignatureMethodType $signatureMethod
     * @param \Sabre\QueueCount\Structs\ReferenceType[] $reference
     * @param string $id
     */
    public function __construct(\Sabre\QueueCount\Structs\CanonicalizationMethodType $canonicalizationMethod = null, \Sabre\QueueCount\Structs\SignatureMethodType $signatureMethod = null, array $reference = array(), $id = null)
    {
        $this
            ->setCanonicalizationMethod($canonicalizationMethod)
            ->setSignatureMethod($signatureMethod)
            ->setReference($reference)
            ->setId($id);
    }
    /**
     * Get CanonicalizationMethod value
     * @return \Sabre\QueueCount\Structs\CanonicalizationMethodType|null
     */
    public function getCanonicalizationMethod()
    {
        return $this->CanonicalizationMethod;
    }
    /**
     * Set CanonicalizationMethod value
     * @param \Sabre\QueueCount\Structs\CanonicalizationMethodType $canonicalizationMethod
     * @return \Sabre\QueueCount\Structs\SignedInfoType
     */
    public function setCanonicalizationMethod(\Sabre\QueueCount\Structs\CanonicalizationMethodType $canonicalizationMethod = null)
    {
        $this->CanonicalizationMethod = $canonicalizationMethod;
        return $this;
    }
    /**
     * Get SignatureMethod value
     * @return \Sabre\QueueCount\Structs\SignatureMethodType|null
     */
    public function getSignatureMethod()
    {
        return $this->SignatureMethod;
    }
    /**
     * Set SignatureMethod value
     * @param \Sabre\QueueCount\Structs\SignatureMethodType $signatureMethod
     * @return \Sabre\QueueCount\Structs\SignedInfoType
     */
    public function setSignatureMethod(\Sabre\QueueCount\Structs\SignatureMethodType $signatureMethod = null)
    {
        $this->SignatureMethod = $signatureMethod;
        return $this;
    }
    /**
     * Get Reference value
     * @return \Sabre\QueueCount\Structs\ReferenceType[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ReferenceType[] $reference
     * @return \Sabre\QueueCount\Structs\SignedInfoType
     */
    public function setReference(array $reference = array())
    {
        foreach ($reference as $signedInfoTypeReferenceItem) {
            // validation for constraint: itemType
            if (!$signedInfoTypeReferenceItem instanceof \Sabre\QueueCount\Structs\ReferenceType) {
                throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of \Sabre\QueueCount\Structs\ReferenceType, "%s" given', is_object($signedInfoTypeReferenceItem) ? get_class($signedInfoTypeReferenceItem) : gettype($signedInfoTypeReferenceItem)), __LINE__);
            }
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ReferenceType $item
     * @return \Sabre\QueueCount\Structs\SignedInfoType
     */
    public function addToReference(\Sabre\QueueCount\Structs\ReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\ReferenceType) {
            throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of \Sabre\QueueCount\Structs\ReferenceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\QueueCount\Structs\SignedInfoType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\SignedInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
