<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueIdentifier Structs
 * @subpackage Structs
 */
class QueueIdentifier extends AbstractStructBase
{
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The Range
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\Range
     */
    public $Range;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The AdditionalQueueInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\AdditionalQueueInfo
     */
    public $AdditionalQueueInfo;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Count;
    /**
     * Constructor method for QueueIdentifier
     * @uses QueueIdentifier::setPseudoCityCode()
     * @uses QueueIdentifier::setRange()
     * @uses QueueIdentifier::setName()
     * @uses QueueIdentifier::setNumber()
     * @uses QueueIdentifier::setAdditionalQueueInfo()
     * @uses QueueIdentifier::setCount()
     * @param string $pseudoCityCode
     * @param \Sabre\QueueCount\Structs\Range $range
     * @param string $name
     * @param string $number
     * @param \Sabre\QueueCount\Structs\AdditionalQueueInfo $additionalQueueInfo
     * @param string $count
     */
    public function __construct($pseudoCityCode = null, \Sabre\QueueCount\Structs\Range $range = null, $name = null, $number = null, \Sabre\QueueCount\Structs\AdditionalQueueInfo $additionalQueueInfo = null, $count = null)
    {
        $this
            ->setPseudoCityCode($pseudoCityCode)
            ->setRange($range)
            ->setName($name)
            ->setNumber($number)
            ->setAdditionalQueueInfo($additionalQueueInfo)
            ->setCount($count);
    }
    /**
     * Get PseudoCityCode value
     * @return string
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\QueueCount\Structs\QueueIdentifier
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get Range value
     * @return \Sabre\QueueCount\Structs\Range|null
     */
    public function getRange()
    {
        return $this->Range;
    }
    /**
     * Set Range value
     * @param \Sabre\QueueCount\Structs\Range $range
     * @return \Sabre\QueueCount\Structs\QueueIdentifier
     */
    public function setRange(\Sabre\QueueCount\Structs\Range $range = null)
    {
        $this->Range = $range;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\QueueCount\Structs\QueueIdentifier
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\QueueCount\Structs\QueueIdentifier
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get AdditionalQueueInfo value
     * @return \Sabre\QueueCount\Structs\AdditionalQueueInfo|null
     */
    public function getAdditionalQueueInfo()
    {
        return $this->AdditionalQueueInfo;
    }
    /**
     * Set AdditionalQueueInfo value
     * @param \Sabre\QueueCount\Structs\AdditionalQueueInfo $additionalQueueInfo
     * @return \Sabre\QueueCount\Structs\QueueIdentifier
     */
    public function setAdditionalQueueInfo(\Sabre\QueueCount\Structs\AdditionalQueueInfo $additionalQueueInfo = null)
    {
        $this->AdditionalQueueInfo = $additionalQueueInfo;
        return $this;
    }
    /**
     * Get Count value
     * @return string|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param string $count
     * @return \Sabre\QueueCount\Structs\QueueIdentifier
     */
    public function setCount($count = null)
    {
        // validation for constraint: string
        if (!is_null($count) && !is_string($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\QueueIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
