<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueCountRQ Structs
 * @subpackage Structs
 */
class QueueCountRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - fixed: 2.2.0
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The QueueInfo
     * @var \Sabre\QueueCount\Structs\QueueInfo
     */
    public $QueueInfo;
    /**
     * The Selection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 8
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\Selection[]
     */
    public $Selection;
    /**
     * The ReturnHostCommand
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReturnHostCommand;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for QueueCountRQ
     * @uses QueueCountRQ::setVersion()
     * @uses QueueCountRQ::setQueueInfo()
     * @uses QueueCountRQ::setSelection()
     * @uses QueueCountRQ::setReturnHostCommand()
     * @uses QueueCountRQ::setTimeStamp()
     * @param string $version
     * @param \Sabre\QueueCount\Structs\QueueInfo $queueInfo
     * @param \Sabre\QueueCount\Structs\Selection[] $selection
     * @param bool $returnHostCommand
     * @param string $timeStamp
     */
    public function __construct($version = null, \Sabre\QueueCount\Structs\QueueInfo $queueInfo = null, array $selection = array(), $returnHostCommand = null, $timeStamp = null)
    {
        $this
            ->setVersion($version)
            ->setQueueInfo($queueInfo)
            ->setSelection($selection)
            ->setReturnHostCommand($returnHostCommand)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\QueueCount\Structs\QueueCountRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get QueueInfo value
     * @return \Sabre\QueueCount\Structs\QueueInfo|null
     */
    public function getQueueInfo()
    {
        return $this->QueueInfo;
    }
    /**
     * Set QueueInfo value
     * @param \Sabre\QueueCount\Structs\QueueInfo $queueInfo
     * @return \Sabre\QueueCount\Structs\QueueCountRQ
     */
    public function setQueueInfo(\Sabre\QueueCount\Structs\QueueInfo $queueInfo = null)
    {
        $this->QueueInfo = $queueInfo;
        return $this;
    }
    /**
     * Get Selection value
     * @return \Sabre\QueueCount\Structs\Selection[]|null
     */
    public function getSelection()
    {
        return $this->Selection;
    }
    /**
     * Set Selection value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Selection[] $selection
     * @return \Sabre\QueueCount\Structs\QueueCountRQ
     */
    public function setSelection(array $selection = array())
    {
        foreach ($selection as $queueCountRQSelectionItem) {
            // validation for constraint: itemType
            if (!$queueCountRQSelectionItem instanceof \Sabre\QueueCount\Structs\Selection) {
                throw new \InvalidArgumentException(sprintf('The Selection property can only contain items of \Sabre\QueueCount\Structs\Selection, "%s" given', is_object($queueCountRQSelectionItem) ? get_class($queueCountRQSelectionItem) : gettype($queueCountRQSelectionItem)), __LINE__);
            }
        }
        $this->Selection = $selection;
        return $this;
    }
    /**
     * Add item to Selection value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Selection $item
     * @return \Sabre\QueueCount\Structs\QueueCountRQ
     */
    public function addToSelection(\Sabre\QueueCount\Structs\Selection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\Selection) {
            throw new \InvalidArgumentException(sprintf('The Selection property can only contain items of \Sabre\QueueCount\Structs\Selection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Selection[] = $item;
        return $this;
    }
    /**
     * Get ReturnHostCommand value
     * @return bool|null
     */
    public function getReturnHostCommand()
    {
        return $this->ReturnHostCommand;
    }
    /**
     * Set ReturnHostCommand value
     * @param bool $returnHostCommand
     * @return \Sabre\QueueCount\Structs\QueueCountRQ
     */
    public function setReturnHostCommand($returnHostCommand = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnHostCommand) && !is_bool($returnHostCommand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnHostCommand)), __LINE__);
        }
        $this->ReturnHostCommand = $returnHostCommand;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\QueueCount\Structs\QueueCountRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($timeStamp) && !preg_match('/(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}/', $timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}", "%s" given', var_export($timeStamp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\QueueCountRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
