<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identifier.System Structs
 * Meta informations extracted from the WSDL
 * - documentation: System identifier used to uniquily identify the specific system. "Source" is used to return the application name responsible for fulfilling the particular request transaction. "ApplicationInstance" is used to return the application
 * instance responsible for fulfilling the particular request transaction. "Cluster" is used to return the application cluster responsible for fulfilling the particular request transaction. "HostName" is used to return the particular server name
 * responsible for fulfilling the particular request transaction.  Example: Source ApplicationInstance="PROD1" Cluster="PROD TPF SCC" HostName="PSS" TPF Source
 * - maxLength: 255
 * - minLength: 1
 * @subpackage Structs
 */
class Identifier_System extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The instance
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $instance;
    /**
     * The cluster
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $cluster;
    /**
     * The host
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $host;
    /**
     * The uri
     * Meta informations extracted from the WSDL
     * - documentation: The uri representing the endpoint reference by which this system can be accessed.
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $uri;
    /**
     * Constructor method for Identifier.System
     * @uses Identifier_System::set_()
     * @uses Identifier_System::setInstance()
     * @uses Identifier_System::setCluster()
     * @uses Identifier_System::setHost()
     * @uses Identifier_System::setUri()
     * @param string $_
     * @param string $instance
     * @param string $cluster
     * @param string $host
     * @param string $uri
     */
    public function __construct($_ = null, $instance = null, $cluster = null, $host = null, $uri = null)
    {
        $this
            ->set_($_)
            ->setInstance($instance)
            ->setCluster($cluster)
            ->setHost($host)
            ->setUri($uri);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\QueueCount\Structs\Identifier_System
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 255) || (is_array($_) && count($_) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($_) && strlen($_) < 1) || (is_array($_) && count($_) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get instance value
     * @return string|null
     */
    public function getInstance()
    {
        return $this->instance;
    }
    /**
     * Set instance value
     * @param string $instance
     * @return \Sabre\QueueCount\Structs\Identifier_System
     */
    public function setInstance($instance = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($instance) && strlen($instance) > 255) || (is_array($instance) && count($instance) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($instance) ? strlen($instance) : count($instance)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($instance) && strlen($instance) < 1) || (is_array($instance) && count($instance) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($instance) && !is_string($instance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instance)), __LINE__);
        }
        $this->instance = $instance;
        return $this;
    }
    /**
     * Get cluster value
     * @return string|null
     */
    public function getCluster()
    {
        return $this->cluster;
    }
    /**
     * Set cluster value
     * @param string $cluster
     * @return \Sabre\QueueCount\Structs\Identifier_System
     */
    public function setCluster($cluster = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cluster) && strlen($cluster) > 255) || (is_array($cluster) && count($cluster) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($cluster) ? strlen($cluster) : count($cluster)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cluster) && strlen($cluster) < 1) || (is_array($cluster) && count($cluster) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cluster) && !is_string($cluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cluster)), __LINE__);
        }
        $this->cluster = $cluster;
        return $this;
    }
    /**
     * Get host value
     * @return string|null
     */
    public function getHost()
    {
        return $this->host;
    }
    /**
     * Set host value
     * @param string $host
     * @return \Sabre\QueueCount\Structs\Identifier_System
     */
    public function setHost($host = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($host) && strlen($host) > 255) || (is_array($host) && count($host) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($host) ? strlen($host) : count($host)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($host) && strlen($host) < 1) || (is_array($host) && count($host) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($host) && !is_string($host)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($host)), __LINE__);
        }
        $this->host = $host;
        return $this;
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \Sabre\QueueCount\Structs\Identifier_System
     */
    public function setUri($uri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uri) && strlen($uri) > 255) || (is_array($uri) && count($uri) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($uri) ? strlen($uri) : count($uri)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($uri) && strlen($uri) < 1) || (is_array($uri) && count($uri) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\Identifier_System
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
