<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identification Structs
 * Meta informations extracted from the WSDL
 * - documentation: The Identification metadata uniquely identify each message instance.
 * - type: Identification
 * @subpackage Structs
 */
class Identification extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Customer Identifier assigned to office or agency or location. Commonly use values are Psuedo City Code - 3 to 16 characters or the Sabre Office accounting code (OAC) which can be upto 25 characters.
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $CustomerID;
    /**
     * The ConversationID
     * Meta informations extracted from the WSDL
     * - documentation: The ConversationId element is a string identifying the set of related messages that make up a conversation between two or more Parties. The Party initiating a conversation determines the value of the ConversationId element that shall
     * be reflected in all messages pertaining to that conversation. It remains constant for all messages within a conversation. Service providers are expected to increment the optional TrackingID integer attribute when present.
     * - minOccurs: 1
     * @var \Sabre\QueueCount\Structs\TrackingID
     */
    public $ConversationID;
    /**
     * The MessageID
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $MessageID;
    /**
     * The CustomerAppID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $CustomerAppID;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for Identification
     * @uses Identification::setCustomerID()
     * @uses Identification::setConversationID()
     * @uses Identification::setMessageID()
     * @uses Identification::setCustomerAppID()
     * @uses Identification::setTimeStamp()
     * @param string $customerID
     * @param \Sabre\QueueCount\Structs\TrackingID $conversationID
     * @param string $messageID
     * @param string $customerAppID
     * @param string $timeStamp
     */
    public function __construct($customerID = null, \Sabre\QueueCount\Structs\TrackingID $conversationID = null, $messageID = null, $customerAppID = null, $timeStamp = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setConversationID($conversationID)
            ->setMessageID($messageID)
            ->setCustomerAppID($customerAppID)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get CustomerID value
     * @return string
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \Sabre\QueueCount\Structs\Identification
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerID) && strlen($customerID) > 25) || (is_array($customerID) && count($customerID) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($customerID) ? strlen($customerID) : count($customerID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($customerID) && strlen($customerID) < 1) || (is_array($customerID) && count($customerID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ConversationID value
     * @return \Sabre\QueueCount\Structs\TrackingID
     */
    public function getConversationID()
    {
        return $this->ConversationID;
    }
    /**
     * Set ConversationID value
     * @param \Sabre\QueueCount\Structs\TrackingID $conversationID
     * @return \Sabre\QueueCount\Structs\Identification
     */
    public function setConversationID(\Sabre\QueueCount\Structs\TrackingID $conversationID = null)
    {
        $this->ConversationID = $conversationID;
        return $this;
    }
    /**
     * Get MessageID value
     * @return string
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param string $messageID
     * @return \Sabre\QueueCount\Structs\Identification
     */
    public function setMessageID($messageID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageID) && strlen($messageID) > 255) || (is_array($messageID) && count($messageID) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($messageID) ? strlen($messageID) : count($messageID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageID) && strlen($messageID) < 1) || (is_array($messageID) && count($messageID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageID) && !is_string($messageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageID)), __LINE__);
        }
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get CustomerAppID value
     * @return string|null
     */
    public function getCustomerAppID()
    {
        return $this->CustomerAppID;
    }
    /**
     * Set CustomerAppID value
     * @param string $customerAppID
     * @return \Sabre\QueueCount\Structs\Identification
     */
    public function setCustomerAppID($customerAppID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerAppID) && strlen($customerAppID) > 128) || (is_array($customerAppID) && count($customerAppID) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($customerAppID) ? strlen($customerAppID) : count($customerAppID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($customerAppID) && strlen($customerAppID) < 1) || (is_array($customerAppID) && count($customerAppID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerAppID) && !is_string($customerAppID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerAppID)), __LINE__);
        }
        $this->CustomerAppID = $customerAppID;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\QueueCount\Structs\Identification
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($timeStamp) && !preg_match('/(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}/', $timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}", "%s" given', var_export($timeStamp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\Identification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
