<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Diagnostics Structs
 * Meta informations extracted from the WSDL
 * - type: Diagnostics
 * @subpackage Structs
 */
class Diagnostics extends AbstractStructBase
{
    /**
     * The Level
     * Meta informations extracted from the WSDL
     * - documentation: Describes the level of diagnostic data requested or provided.
     * - minOccurs: 0
     * @var string
     */
    public $Level;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Block of diagnostic data included in request or returned in the response. | Same as STL Text.Long - A field text characters and no other constraints.
     * - minOccurs: 0
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $Data;
    /**
     * The Diagnostic
     * Meta informations extracted from the WSDL
     * - documentation: Diagnostic data. Must be defined in a differrent namespace as the header.
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\DiagnosticResults
     */
    public $Diagnostic;
    /**
     * Constructor method for Diagnostics
     * @uses Diagnostics::setLevel()
     * @uses Diagnostics::setData()
     * @uses Diagnostics::setDiagnostic()
     * @param string $level
     * @param string $data
     * @param \Sabre\QueueCount\Structs\DiagnosticResults $diagnostic
     */
    public function __construct($level = null, $data = null, \Sabre\QueueCount\Structs\DiagnosticResults $diagnostic = null)
    {
        $this
            ->setLevel($level)
            ->setData($data)
            ->setDiagnostic($diagnostic);
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @uses \Sabre\QueueCount\Enums\DiagnosticLevels::valueIsValid()
     * @uses \Sabre\QueueCount\Enums\DiagnosticLevels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \Sabre\QueueCount\Structs\Diagnostics
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\Sabre\QueueCount\Enums\DiagnosticLevels::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $level, implode(', ', \Sabre\QueueCount\Enums\DiagnosticLevels::getValidValues())), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \Sabre\QueueCount\Structs\Diagnostics
     */
    public function setData($data = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($data) && strlen($data) > 4096) || (is_array($data) && count($data) > 4096)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4096 element(s) or a scalar of 4096 character(s) at most, "%d" length given', is_scalar($data) ? strlen($data) : count($data)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($data) && strlen($data) < 0) || (is_array($data) && count($data) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Diagnostic value
     * @return \Sabre\QueueCount\Structs\DiagnosticResults|null
     */
    public function getDiagnostic()
    {
        return $this->Diagnostic;
    }
    /**
     * Set Diagnostic value
     * @param \Sabre\QueueCount\Structs\DiagnosticResults $diagnostic
     * @return \Sabre\QueueCount\Structs\Diagnostics
     */
    public function setDiagnostic(\Sabre\QueueCount\Structs\DiagnosticResults $diagnostic = null)
    {
        $this->Diagnostic = $diagnostic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\Diagnostics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
