<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingID Structs
 * Meta informations extracted from the WSDL
 * - documentation: Tracking Identifier is an identifier intended for use to a set of related items and provide an optional sequence number for the items.
 * - maxLength: 255
 * - minLength: 1
 * @subpackage Structs
 */
class TrackingID extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The seq
     * @var int
     */
    public $seq;
    /**
     * Constructor method for TrackingID
     * @uses TrackingID::set_()
     * @uses TrackingID::setSeq()
     * @param string $_
     * @param int $seq
     */
    public function __construct($_ = null, $seq = null)
    {
        $this
            ->set_($_)
            ->setSeq($seq);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\QueueCount\Structs\TrackingID
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 255) || (is_array($_) && count($_) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($_) && strlen($_) < 1) || (is_array($_) && count($_) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get seq value
     * @return int|null
     */
    public function getSeq()
    {
        return $this->seq;
    }
    /**
     * Set seq value
     * @param int $seq
     * @return \Sabre\QueueCount\Structs\TrackingID
     */
    public function setSeq($seq = null)
    {
        // validation for constraint: int
        if (!is_null($seq) && !is_numeric($seq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seq)), __LINE__);
        }
        $this->seq = $seq;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\TrackingID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
