<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemSpecificResults Structs
 * @subpackage Structs
 */
class SystemSpecificResults extends AbstractStructBase
{
    /**
     * The HostCommand
     * Meta informations extracted from the WSDL
     * - documentation: Host system command run to create this result.
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\HostCommand
     */
    public $HostCommand;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Application specific code and Message. A textual description to provide more information about the specific condition, warning or error with code attribute as numeric value.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\Message_Condition[]
     */
    public $Message;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - documentation: An abbreviated version of the error in textual format. | Same as STL Text.Short - A field of text characters and no other constraints.
     * - minOccurs: 0
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $ShortText;
    /**
     * The Element
     * Meta informations extracted from the WSDL
     * - documentation: If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one
     * tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing]. | Same as STL Text.Long - A field text characters and no other constraints.
     * - minOccurs: 0
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $Element;
    /**
     * The RecordID
     * Meta informations extracted from the WSDL
     * - documentation: If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. This value may contain a concatenation of a unique failed transaction ID with specific record(s)
     * associated with that transaction.
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $RecordID;
    /**
     * The DocURL
     * Meta informations extracted from the WSDL
     * - documentation: If present, this attribute refers to an online description of the error that occurred.
     * - minOccurs: 0
     * @var string
     */
    public $DocURL;
    /**
     * The timeStamp
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $timeStamp;
    /**
     * Constructor method for SystemSpecificResults
     * @uses SystemSpecificResults::setHostCommand()
     * @uses SystemSpecificResults::setMessage()
     * @uses SystemSpecificResults::setShortText()
     * @uses SystemSpecificResults::setElement()
     * @uses SystemSpecificResults::setRecordID()
     * @uses SystemSpecificResults::setDocURL()
     * @uses SystemSpecificResults::setTimeStamp()
     * @param \Sabre\QueueCount\Structs\HostCommand $hostCommand
     * @param \Sabre\QueueCount\Structs\Message_Condition[] $message
     * @param string $shortText
     * @param string $element
     * @param string $recordID
     * @param string $docURL
     * @param string $timeStamp
     */
    public function __construct(\Sabre\QueueCount\Structs\HostCommand $hostCommand = null, array $message = array(), $shortText = null, $element = null, $recordID = null, $docURL = null, $timeStamp = null)
    {
        $this
            ->setHostCommand($hostCommand)
            ->setMessage($message)
            ->setShortText($shortText)
            ->setElement($element)
            ->setRecordID($recordID)
            ->setDocURL($docURL)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get HostCommand value
     * @return \Sabre\QueueCount\Structs\HostCommand|null
     */
    public function getHostCommand()
    {
        return $this->HostCommand;
    }
    /**
     * Set HostCommand value
     * @param \Sabre\QueueCount\Structs\HostCommand $hostCommand
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public function setHostCommand(\Sabre\QueueCount\Structs\HostCommand $hostCommand = null)
    {
        $this->HostCommand = $hostCommand;
        return $this;
    }
    /**
     * Get Message value
     * @return \Sabre\QueueCount\Structs\Message_Condition[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Message_Condition[] $message
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $systemSpecificResultsMessageItem) {
            // validation for constraint: itemType
            if (!$systemSpecificResultsMessageItem instanceof \Sabre\QueueCount\Structs\Message_Condition) {
                throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \Sabre\QueueCount\Structs\Message_Condition, "%s" given', is_object($systemSpecificResultsMessageItem) ? get_class($systemSpecificResultsMessageItem) : gettype($systemSpecificResultsMessageItem)), __LINE__);
            }
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Message_Condition $item
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public function addToMessage(\Sabre\QueueCount\Structs\Message_Condition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\Message_Condition) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \Sabre\QueueCount\Structs\Message_Condition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public function setShortText($shortText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shortText) && strlen($shortText) > 128) || (is_array($shortText) && count($shortText) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($shortText) ? strlen($shortText) : count($shortText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($shortText) && strlen($shortText) < 1) || (is_array($shortText) && count($shortText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shortText) && !is_string($shortText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortText)), __LINE__);
        }
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Element value
     * @return string|null
     */
    public function getElement()
    {
        return $this->Element;
    }
    /**
     * Set Element value
     * @param string $element
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public function setElement($element = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($element) && strlen($element) > 4096) || (is_array($element) && count($element) > 4096)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4096 element(s) or a scalar of 4096 character(s) at most, "%d" length given', is_scalar($element) ? strlen($element) : count($element)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($element) && strlen($element) < 0) || (is_array($element) && count($element) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($element) && !is_string($element)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($element)), __LINE__);
        }
        $this->Element = $element;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recordID) && strlen($recordID) > 255) || (is_array($recordID) && count($recordID) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($recordID) ? strlen($recordID) : count($recordID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recordID) && strlen($recordID) < 1) || (is_array($recordID) && count($recordID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Get DocURL value
     * @return string|null
     */
    public function getDocURL()
    {
        return $this->DocURL;
    }
    /**
     * Set DocURL value
     * @param string $docURL
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public function setDocURL($docURL = null)
    {
        // validation for constraint: string
        if (!is_null($docURL) && !is_string($docURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docURL)), __LINE__);
        }
        $this->DocURL = $docURL;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($timeStamp) && !preg_match('/(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}/', $timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}", "%s" given', var_export($timeStamp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\SystemSpecificResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
