<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType Structs
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta informations extracted from the WSDL
     * - ref: ds:SignedInfo
     * @var \Sabre\QueueCount\Structs\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta informations extracted from the WSDL
     * - ref: ds:SignatureValue
     * @var \Sabre\QueueCount\Structs\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:KeyInfo
     * @var \Sabre\QueueCount\Structs\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Object
     * @var \Sabre\QueueCount\Structs\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @param \Sabre\QueueCount\Structs\SignedInfoType $signedInfo
     * @param \Sabre\QueueCount\Structs\SignatureValueType $signatureValue
     * @param \Sabre\QueueCount\Structs\KeyInfoType $keyInfo
     * @param \Sabre\QueueCount\Structs\ObjectType[] $object
     * @param string $id
     */
    public function __construct(\Sabre\QueueCount\Structs\SignedInfoType $signedInfo = null, \Sabre\QueueCount\Structs\SignatureValueType $signatureValue = null, \Sabre\QueueCount\Structs\KeyInfoType $keyInfo = null, array $object = array(), $id = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id);
    }
    /**
     * Get SignedInfo value
     * @return \Sabre\QueueCount\Structs\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \Sabre\QueueCount\Structs\SignedInfoType $signedInfo
     * @return \Sabre\QueueCount\Structs\SignatureType
     */
    public function setSignedInfo(\Sabre\QueueCount\Structs\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \Sabre\QueueCount\Structs\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \Sabre\QueueCount\Structs\SignatureValueType $signatureValue
     * @return \Sabre\QueueCount\Structs\SignatureType
     */
    public function setSignatureValue(\Sabre\QueueCount\Structs\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \Sabre\QueueCount\Structs\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \Sabre\QueueCount\Structs\KeyInfoType $keyInfo
     * @return \Sabre\QueueCount\Structs\SignatureType
     */
    public function setKeyInfo(\Sabre\QueueCount\Structs\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \Sabre\QueueCount\Structs\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ObjectType[] $object
     * @return \Sabre\QueueCount\Structs\SignatureType
     */
    public function setObject(array $object = array())
    {
        foreach ($object as $signatureTypeObjectItem) {
            // validation for constraint: itemType
            if (!$signatureTypeObjectItem instanceof \Sabre\QueueCount\Structs\ObjectType) {
                throw new \InvalidArgumentException(sprintf('The Object property can only contain items of \Sabre\QueueCount\Structs\ObjectType, "%s" given', is_object($signatureTypeObjectItem) ? get_class($signatureTypeObjectItem) : gettype($signatureTypeObjectItem)), __LINE__);
            }
        }
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ObjectType $item
     * @return \Sabre\QueueCount\Structs\SignatureType
     */
    public function addToObject(\Sabre\QueueCount\Structs\ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Object property can only contain items of \Sabre\QueueCount\Structs\ObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\QueueCount\Structs\SignatureType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\SignatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
