<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service Structs
 * Meta informations extracted from the WSDL
 * - type: Service
 * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
 * - maxLength: 128
 * - minLength: 1
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The operation
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $operation;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * The ttl
     * @var int
     */
    public $ttl;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $type;
    /**
     * Constructor method for Service
     * @uses Service::set_()
     * @uses Service::setOperation()
     * @uses Service::setVersion()
     * @uses Service::setTtl()
     * @uses Service::setType()
     * @param string $_
     * @param string $operation
     * @param string $version
     * @param int $ttl
     * @param string $type
     */
    public function __construct($_ = null, $operation = null, $version = null, $ttl = null, $type = null)
    {
        $this
            ->set_($_)
            ->setOperation($operation)
            ->setVersion($version)
            ->setTtl($ttl)
            ->setType($type);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\QueueCount\Structs\Service
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 128) || (is_array($_) && count($_) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($_) && strlen($_) < 1) || (is_array($_) && count($_) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @param string $operation
     * @return \Sabre\QueueCount\Structs\Service
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operation) && strlen($operation) > 128) || (is_array($operation) && count($operation) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($operation) ? strlen($operation) : count($operation)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($operation) && strlen($operation) < 1) || (is_array($operation) && count($operation) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operation)), __LINE__);
        }
        $this->operation = $operation;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\QueueCount\Structs\Service
     */
    public function setVersion($version = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($version) && strlen($version) > 128) || (is_array($version) && count($version) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($version) ? strlen($version) : count($version)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($version) && strlen($version) < 1) || (is_array($version) && count($version) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get ttl value
     * @return int|null
     */
    public function getTtl()
    {
        return $this->ttl;
    }
    /**
     * Set ttl value
     * @param int $ttl
     * @return \Sabre\QueueCount\Structs\Service
     */
    public function setTtl($ttl = null)
    {
        // validation for constraint: int
        if (!is_null($ttl) && !is_numeric($ttl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ttl)), __LINE__);
        }
        $this->ttl = $ttl;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\QueueCount\Structs\Service
     */
    public function setType($type = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($type) && strlen($type) < 1) || (is_array($type) && count($type) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
