<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security Structs
 * Meta informations extracted from the WSDL
 * - Prefix: wsse
 * - documentation: Header records no longer contain user credentials (username/password) as these are needed only for SessionCreateRQ in which the credentials should be in the payload.
 * - type: Security
 * @subpackage Structs
 */
class Security extends AbstractStructBase
{
    /**
     * The SecurityToken
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Long - A field text characters and no other constraints.
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $SecurityToken;
    /**
     * The UsernameToken
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\UsernameToken
     */
    public $UsernameToken;
    /**
     * The SabreAth
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $SabreAth;
    /**
     * The BinarySecurityToken
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $BinarySecurityToken;
    /**
     * Constructor method for Security
     * @uses Security::setSecurityToken()
     * @uses Security::setUsernameToken()
     * @uses Security::setSabreAth()
     * @uses Security::setBinarySecurityToken()
     * @param string $securityToken
     * @param \Sabre\QueueCount\Structs\UsernameToken $usernameToken
     * @param string $sabreAth
     * @param string $binarySecurityToken
     */
    public function __construct($securityToken = null, \Sabre\QueueCount\Structs\UsernameToken $usernameToken = null, $sabreAth = null, $binarySecurityToken = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setUsernameToken($usernameToken)
            ->setSabreAth($sabreAth)
            ->setBinarySecurityToken($binarySecurityToken);
    }
    /**
     * Get SecurityToken value
     * @return string|null
     */
    public function getSecurityToken()
    {
        return $this->SecurityToken;
    }
    /**
     * Set SecurityToken value
     * @param string $securityToken
     * @return \Sabre\QueueCount\Structs\Security
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($securityToken) && strlen($securityToken) > 4096) || (is_array($securityToken) && count($securityToken) > 4096)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4096 element(s) or a scalar of 4096 character(s) at most, "%d" length given', is_scalar($securityToken) ? strlen($securityToken) : count($securityToken)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($securityToken) && strlen($securityToken) < 0) || (is_array($securityToken) && count($securityToken) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityToken)), __LINE__);
        }
        $this->SecurityToken = $securityToken;
        return $this;
    }
    /**
     * Get UsernameToken value
     * @return \Sabre\QueueCount\Structs\UsernameToken|null
     */
    public function getUsernameToken()
    {
        return $this->UsernameToken;
    }
    /**
     * Set UsernameToken value
     * @param \Sabre\QueueCount\Structs\UsernameToken $usernameToken
     * @return \Sabre\QueueCount\Structs\Security
     */
    public function setUsernameToken(\Sabre\QueueCount\Structs\UsernameToken $usernameToken = null)
    {
        $this->UsernameToken = $usernameToken;
        return $this;
    }
    /**
     * Get SabreAth value
     * @return string|null
     */
    public function getSabreAth()
    {
        return $this->SabreAth;
    }
    /**
     * Set SabreAth value
     * @param string $sabreAth
     * @return \Sabre\QueueCount\Structs\Security
     */
    public function setSabreAth($sabreAth = null)
    {
        // validation for constraint: string
        if (!is_null($sabreAth) && !is_string($sabreAth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sabreAth)), __LINE__);
        }
        $this->SabreAth = $sabreAth;
        return $this;
    }
    /**
     * Get BinarySecurityToken value
     * @return string|null
     */
    public function getBinarySecurityToken()
    {
        return $this->BinarySecurityToken;
    }
    /**
     * Set BinarySecurityToken value
     * @param string $binarySecurityToken
     * @return \Sabre\QueueCount\Structs\Security
     */
    public function setBinarySecurityToken($binarySecurityToken = null)
    {
        // validation for constraint: string
        if (!is_null($binarySecurityToken) && !is_string($binarySecurityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($binarySecurityToken)), __LINE__);
        }
        $this->BinarySecurityToken = $binarySecurityToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\Security
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
