<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueCountRS Structs
 * @subpackage Structs
 */
class QueueCountRS extends AbstractStructBase
{
    /**
     * The ApplicationResults
     * Meta informations extracted from the WSDL
     * - ref: stl:ApplicationResults
     * @var \Sabre\QueueCount\Structs\ApplicationResults
     */
    public $ApplicationResults;
    /**
     * The QueueInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\QueueInfo
     */
    public $QueueInfo;
    /**
     * The Totals
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\Totals[]
     */
    public $Totals;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - fixed: 2.2.0
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for QueueCountRS
     * @uses QueueCountRS::setApplicationResults()
     * @uses QueueCountRS::setQueueInfo()
     * @uses QueueCountRS::setTotals()
     * @uses QueueCountRS::setVersion()
     * @param \Sabre\QueueCount\Structs\ApplicationResults $applicationResults
     * @param \Sabre\QueueCount\Structs\QueueInfo $queueInfo
     * @param \Sabre\QueueCount\Structs\Totals[] $totals
     * @param string $version
     */
    public function __construct(\Sabre\QueueCount\Structs\ApplicationResults $applicationResults = null, \Sabre\QueueCount\Structs\QueueInfo $queueInfo = null, array $totals = array(), $version = null)
    {
        $this
            ->setApplicationResults($applicationResults)
            ->setQueueInfo($queueInfo)
            ->setTotals($totals)
            ->setVersion($version);
    }
    /**
     * Get ApplicationResults value
     * @return \Sabre\QueueCount\Structs\ApplicationResults|null
     */
    public function getApplicationResults()
    {
        return $this->ApplicationResults;
    }
    /**
     * Set ApplicationResults value
     * @param \Sabre\QueueCount\Structs\ApplicationResults $applicationResults
     * @return \Sabre\QueueCount\Structs\QueueCountRS
     */
    public function setApplicationResults(\Sabre\QueueCount\Structs\ApplicationResults $applicationResults = null)
    {
        $this->ApplicationResults = $applicationResults;
        return $this;
    }
    /**
     * Get QueueInfo value
     * @return \Sabre\QueueCount\Structs\QueueInfo|null
     */
    public function getQueueInfo()
    {
        return $this->QueueInfo;
    }
    /**
     * Set QueueInfo value
     * @param \Sabre\QueueCount\Structs\QueueInfo $queueInfo
     * @return \Sabre\QueueCount\Structs\QueueCountRS
     */
    public function setQueueInfo(\Sabre\QueueCount\Structs\QueueInfo $queueInfo = null)
    {
        $this->QueueInfo = $queueInfo;
        return $this;
    }
    /**
     * Get Totals value
     * @return \Sabre\QueueCount\Structs\Totals[]|null
     */
    public function getTotals()
    {
        return $this->Totals;
    }
    /**
     * Set Totals value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Totals[] $totals
     * @return \Sabre\QueueCount\Structs\QueueCountRS
     */
    public function setTotals(array $totals = array())
    {
        foreach ($totals as $queueCountRSTotalsItem) {
            // validation for constraint: itemType
            if (!$queueCountRSTotalsItem instanceof \Sabre\QueueCount\Structs\Totals) {
                throw new \InvalidArgumentException(sprintf('The Totals property can only contain items of \Sabre\QueueCount\Structs\Totals, "%s" given', is_object($queueCountRSTotalsItem) ? get_class($queueCountRSTotalsItem) : gettype($queueCountRSTotalsItem)), __LINE__);
            }
        }
        $this->Totals = $totals;
        return $this;
    }
    /**
     * Add item to Totals value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Totals $item
     * @return \Sabre\QueueCount\Structs\QueueCountRS
     */
    public function addToTotals(\Sabre\QueueCount\Structs\Totals $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\Totals) {
            throw new \InvalidArgumentException(sprintf('The Totals property can only contain items of \Sabre\QueueCount\Structs\Totals, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Totals[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\QueueCount\Structs\QueueCountRS
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\QueueCountRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
