<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Manifest Structs
 * Meta informations extracted from the WSDL
 * - type: ds:ManifestType
 * @subpackage Structs
 */
class Manifest extends AbstractStructBase
{
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:Reference
     * @var \Sabre\QueueCount\Structs\Reference[]
     */
    public $Reference;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for Manifest
     * @uses Manifest::setReference()
     * @uses Manifest::setAny()
     * @uses Manifest::setId()
     * @uses Manifest::setVersion()
     * @param \Sabre\QueueCount\Structs\Reference[] $reference
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct(array $reference = array(), \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setReference($reference)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get Reference value
     * @return \Sabre\QueueCount\Structs\Reference[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Reference[] $reference
     * @return \Sabre\QueueCount\Structs\Manifest
     */
    public function setReference(array $reference = array())
    {
        foreach ($reference as $manifestReferenceItem) {
            // validation for constraint: itemType
            if (!$manifestReferenceItem instanceof \Sabre\QueueCount\Structs\Reference) {
                throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of \Sabre\QueueCount\Structs\Reference, "%s" given', is_object($manifestReferenceItem) ? get_class($manifestReferenceItem) : gettype($manifestReferenceItem)), __LINE__);
            }
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Reference $item
     * @return \Sabre\QueueCount\Structs\Manifest
     */
    public function addToReference(\Sabre\QueueCount\Structs\Reference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\Reference) {
            throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of \Sabre\QueueCount\Structs\Reference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\QueueCount\Structs\Manifest::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\QueueCount\Structs\Manifest
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\QueueCount\Structs\Manifest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\QueueCount\Structs\Manifest
     */
    public function setVersion($version = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($version) && strlen($version) < 1) || (is_array($version) && count($version) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\Manifest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
